/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;

@Component
public class IdpTokenExpiredAction {
    private static final Logger LOG = LoggerFactory.getLogger(IdpTokenExpiredAction.class);
    private boolean tokenExpirationValidation = true;

    public boolean isTokenExpired(String homeRealm, RequestContext context) throws Exception {
        if (this.tokenExpirationValidation) {
            SecurityToken idpToken = (SecurityToken)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)homeRealm);
            if (idpToken == null) {
                return true;
            }
            if (idpToken.isExpired()) {
                LOG.info("[IDP_TOKEN=" + idpToken.getId() + "] is expired.");
                return true;
            }
        }
        return false;
    }

    public boolean isTokenExpirationValidation() {
        return this.tokenExpirationValidation;
    }

    public void setTokenExpirationValidation(boolean tokenExpirationValidation) {
        this.tokenExpirationValidation = tokenExpirationValidation;
    }
}

