/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.fediz.service.idp.STSAuthenticationProvider;
import org.apache.cxf.fediz.service.idp.STSUserDetails;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class STSUPAuthenticationProvider
extends STSAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(STSUPAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {
            return null;
        }
        Bus cxfBus = this.getBus();
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        if (this.tokenType != null && this.tokenType.length() > 0) {
            sts.setTokenType(this.tokenType);
        } else {
            sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.wsdlLocation);
        sts.setServiceQName(new QName(this.namespace, this.wsdlService));
        sts.setEndpointQName(new QName(this.namespace, this.wsdlEndpoint));
        sts.getProperties().putAll(this.properties);
        if (this.use200502Namespace) {
            sts.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
        }
        if (this.lifetime != null) {
            sts.setEnableLifetime(true);
            sts.setTtl(this.lifetime.intValue());
        }
        return this.handleUsernamePassword((UsernamePasswordAuthenticationToken)authentication, sts);
    }

    private Authentication handleUsernamePassword(UsernamePasswordAuthenticationToken usernamePasswordToken, IdpSTSClient sts) {
        sts.getProperties().put("security.username", usernamePasswordToken.getName());
        sts.getProperties().put("security.password", (String)usernamePasswordToken.getCredentials());
        try {
            SecurityToken token = sts.requestSecurityToken(this.appliesTo);
            List authorities = this.createAuthorities(token);
            UsernamePasswordAuthenticationToken upat = new UsernamePasswordAuthenticationToken((Object)usernamePasswordToken.getName(), usernamePasswordToken.getCredentials(), (Collection)authorities);
            STSUserDetails details = new STSUserDetails(usernamePasswordToken.getName(), (String)usernamePasswordToken.getCredentials(), (Collection)authorities, token);
            upat.setDetails((Object)details);
            LOG.debug("[IDP_TOKEN={}] provided for user '{}'", (Object)token.getId(), (Object)usernamePasswordToken.getName());
            return upat;
        }
        catch (Exception ex) {
            LOG.info("Failed to authenticate user '" + usernamePasswordToken.getName() + "'", (Throwable)ex);
            return null;
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

