/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.fediz.service.idp.STSAuthenticationProvider;
import org.apache.cxf.fediz.service.idp.STSUserDetails;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.w3c.dom.Document;

public class STSPreAuthAuthenticationProvider
extends STSAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(STSPreAuthAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof PreAuthenticatedAuthenticationToken)) {
            return null;
        }
        Bus cxfBus = this.getBus();
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        if (this.tokenType != null && this.tokenType.length() > 0) {
            sts.setTokenType(this.tokenType);
        } else {
            sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.wsdlLocation);
        sts.setServiceQName(new QName(this.namespace, this.wsdlService));
        sts.setEndpointQName(new QName(this.namespace, this.wsdlEndpoint));
        sts.getProperties().putAll(this.properties);
        if (this.use200502Namespace) {
            sts.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
        }
        if (this.lifetime != null) {
            sts.setEnableLifetime(true);
            sts.setTtl(this.lifetime.intValue());
        }
        return this.handlePreAuthenticated((PreAuthenticatedAuthenticationToken)authentication, sts);
    }

    private Authentication handlePreAuthenticated(PreAuthenticatedAuthenticationToken preauthenticatedToken, IdpSTSClient sts) {
        X509Certificate cert = (X509Certificate)preauthenticatedToken.getCredentials();
        if (cert == null) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        X509Data certElem = new X509Data(doc);
        try {
            certElem.addCertificate(cert);
            sts.setOnBehalfOf((Object)certElem.getElement());
        }
        catch (XMLSecurityException e) {
            LOG.debug("Error parsing a client certificate", (Throwable)e);
            return null;
        }
        try {
            SecurityToken token = sts.requestSecurityToken(this.appliesTo);
            List authorities = this.createAuthorities(token);
            STSUserDetails details = new STSUserDetails(preauthenticatedToken.getName(), "", (Collection)authorities, token);
            preauthenticatedToken.setDetails((Object)details);
            LOG.debug("[IDP_TOKEN={}] provided for user '{}'", (Object)token.getId(), (Object)preauthenticatedToken.getName());
            return preauthenticatedToken;
        }
        catch (Exception ex) {
            LOG.info("Failed to authenticate user '" + preauthenticatedToken.getName() + "'", (Throwable)ex);
            return null;
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

