/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cxf.fediz.service.idp.STSAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class STSPortFilter
extends GenericFilterBean
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(STSPortFilter.class);
    private ApplicationContext applicationContext;
    private STSAuthenticationProvider authenticationProvider;
    private boolean isPortSet;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Assert.isTrue((this.applicationContext != null ? 1 : 0) != 0, (String)"Application context must not be null");
        STSAuthenticationProvider authProvider = this.authenticationProvider;
        if (authProvider == null) {
            authProvider = (STSAuthenticationProvider)this.applicationContext.getBean(STSAuthenticationProvider.class);
        }
        Assert.isTrue((authProvider != null ? 1 : 0) != 0, (String)"STSAuthenticationProvider must be configured");
        if (!this.isPortSet && request.isSecure()) {
            try {
                URL url = new URL(authProvider.getWsdlLocation());
                if (url.getPort() == 0) {
                    URL updatedUrl = new URL(url.getProtocol(), url.getHost(), request.getLocalPort(), url.getFile());
                    this.setSTSWsdlUrl(authProvider, updatedUrl.toString());
                    LOG.info("STSAuthenticationProvider.wsdlLocation set to " + updatedUrl.toString());
                } else {
                    this.setSTSWsdlUrl(authProvider, url.toString());
                }
            }
            catch (MalformedURLException e) {
                LOG.error("Invalid Url '" + authProvider.getWsdlLocation() + "': " + e.getMessage());
            }
        }
        chain.doFilter(request, response);
    }

    private synchronized void setSTSWsdlUrl(STSAuthenticationProvider authProvider, String wsdlUrl) {
        authProvider.setWsdlLocation(wsdlUrl);
        this.isPortSet = true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public STSAuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(STSAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

