/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.cxf.fediz.service.idp.domain.Entitlement;
import org.apache.cxf.fediz.service.idp.domain.Role;
import org.apache.cxf.fediz.service.idp.service.RoleDAO;
import org.apache.cxf.fediz.service.idp.service.jpa.EntitlementDAOJPAImpl;
import org.apache.cxf.fediz.service.idp.service.jpa.EntitlementEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.RoleEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Transactional
public class RoleDAOJPAImpl
implements RoleDAO {
    private static final Logger LOG = LoggerFactory.getLogger(RoleDAOJPAImpl.class);
    private EntityManager em;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<Role> getRoles(int start, int size, List<String> expandList) {
        ArrayList<Role> list = new ArrayList<Role>();
        Query query = null;
        query = this.em.createQuery("select r from Role r");
        List roleEntities = query.setFirstResult(start).setMaxResults(size).getResultList();
        for (Object obj : roleEntities) {
            RoleEntity entity = (RoleEntity)obj;
            list.add(RoleDAOJPAImpl.entity2domain((RoleEntity)entity, expandList));
        }
        return list;
    }

    public Role getRole(String name, List<String> expandList) {
        Query query = null;
        query = this.em.createQuery("select r from Role r where r.name=:name");
        query.setParameter("name", (Object)name);
        Object roleObj = query.getSingleResult();
        return RoleDAOJPAImpl.entity2domain((RoleEntity)((RoleEntity)roleObj), expandList);
    }

    public Role addRole(Role role) {
        RoleEntity entity = new RoleEntity();
        RoleDAOJPAImpl.domain2entity((Role)role, (RoleEntity)entity);
        this.em.persist((Object)entity);
        LOG.debug("Role '{}' added", (Object)role.getName());
        return RoleDAOJPAImpl.entity2domain((RoleEntity)entity, Arrays.asList("all"));
    }

    public void updateRole(String name, Role role) {
        Query query = null;
        query = this.em.createQuery("select r from Role r where r.name=:name");
        query.setParameter("name", (Object)name);
        RoleEntity roleEntity = (RoleEntity)query.getSingleResult();
        RoleDAOJPAImpl.domain2entity((Role)role, (RoleEntity)roleEntity);
        this.em.persist((Object)roleEntity);
        LOG.debug("Role '{}' updated", (Object)role.getName());
    }

    public void deleteRole(String name) {
        Query query = null;
        query = this.em.createQuery("select r from Role r where r.name=:name");
        query.setParameter("name", (Object)name);
        Object roleObj = query.getSingleResult();
        this.em.remove(roleObj);
        LOG.debug("Role '{}' deleted", (Object)name);
    }

    public void addEntitlementToRole(Role role, Entitlement entitlement) {
        RoleEntity roleEntity = null;
        roleEntity = role.getId() != 0 ? (RoleEntity)this.em.find(RoleEntity.class, (Object)role.getId()) : RoleDAOJPAImpl.getRoleEntity((String)role.getName(), (EntityManager)this.em);
        EntitlementEntity entitlementEntity = null;
        entitlementEntity = entitlement.getId() != 0 ? (EntitlementEntity)this.em.find(EntitlementEntity.class, (Object)entitlement.getId()) : EntitlementDAOJPAImpl.getEntitlementEntity((String)entitlement.getName(), (EntityManager)this.em);
        roleEntity.getEntitlements().add(entitlementEntity);
        LOG.debug("Entitlement '{}' added to Role '{}'", (Object)entitlement.getName(), (Object)role.getName());
    }

    public void removeEntitlementFromRole(Role role, Entitlement entitlement) {
        RoleEntity roleEntity = null;
        roleEntity = role.getId() != 0 ? (RoleEntity)this.em.find(RoleEntity.class, (Object)role.getId()) : RoleDAOJPAImpl.getRoleEntity((String)role.getName(), (EntityManager)this.em);
        EntitlementEntity entitlementEntity = null;
        entitlementEntity = entitlement.getId() != 0 ? (EntitlementEntity)this.em.find(EntitlementEntity.class, (Object)entitlement.getId()) : EntitlementDAOJPAImpl.getEntitlementEntity((String)entitlement.getName(), (EntityManager)this.em);
        if (entitlementEntity == null) {
            throw new EntityNotFoundException("EntitlementEntity not found");
        }
        if (!roleEntity.getEntitlements().remove(entitlementEntity)) {
            throw new EntityNotFoundException("EntitlementEntity not assigned to RoleEntity");
        }
        LOG.debug("Entitlement '{}' removed from Role '{}'", (Object)entitlement.getName(), (Object)role.getName());
    }

    static RoleEntity getRoleEntity(String realm, EntityManager em) {
        Query query = null;
        query = em.createQuery("select i from IDP i where i.realm=:realm");
        query.setParameter("realm", (Object)realm);
        return (RoleEntity)query.getSingleResult();
    }

    public static void domain2entity(Role role, RoleEntity entity) {
        if (role.getId() > 0) {
            entity.setId(role.getId());
        }
        entity.setName(role.getName());
        entity.setDescription(role.getDescription());
    }

    public static Role entity2domain(RoleEntity entity, List<String> expandList) {
        Role role = new Role();
        role.setId(entity.getId());
        role.setName(entity.getName());
        role.setDescription(entity.getDescription());
        if (expandList != null && (expandList.contains("all") || expandList.contains("entitlements"))) {
            for (EntitlementEntity item : entity.getEntitlements()) {
                Entitlement entitlement = EntitlementDAOJPAImpl.entity2domain((EntitlementEntity)item);
                role.getEntitlements().add(entitlement);
            }
        }
        return role;
    }
}

