/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.bval.jsr303.ConstraintValidatorContextImpl;
import org.apache.cxf.fediz.service.idp.protocols.ProtocolController;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ProtocolSupported;
import org.apache.cxf.fediz.service.idp.service.jpa.TrustedIdpEntity;
import org.apache.cxf.fediz.service.idp.spi.ApplicationProtocolHandler;
import org.apache.cxf.fediz.service.idp.spi.TrustedIdpProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProtocolSupportValidator
implements ConstraintValidator<ProtocolSupported, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolSupportValidator.class);
    @Autowired
    @Qualifier(value="trustedIdpProtocolControllerImpl")
    private ProtocolController<TrustedIdpProtocolHandler> trustedIdpProtocolHandlers;
    @Autowired
    @Qualifier(value="applicationProtocolControllerImpl")
    private ProtocolController<ApplicationProtocolHandler> applicationProtocolHandlers;

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        ConstraintValidatorContextImpl x = (ConstraintValidatorContextImpl)constraintContext;
        Class owner = x.getValidationContext().getCurrentOwner();
        List protocols = null;
        if (owner.equals(TrustedIdpEntity.class)) {
            protocols = this.trustedIdpProtocolHandlers.getProtocols();
        } else if (owner.equals(ApplicationEntity.class)) {
            protocols = this.applicationProtocolHandlers.getProtocols();
        } else {
            LOG.warn("Invalid owner {}. Ignoring validation.", (Object)owner.getCanonicalName());
            return true;
        }
        for (String protocol : protocols) {
            if (!protocol.equals(object)) continue;
            return true;
        }
        return false;
    }

    public void initialize(ProtocolSupported constraintAnnotation) {
    }
}

