/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.DBLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class DBInitApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(DBInitApplicationListener.class);
    private EntityManager em;
    @Autowired
    private List<DBLoader> dbloader;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public void onApplicationEvent(ContextRefreshedEvent arg0) {
        if (!this.isDBEmpty()) {
            LOG.info("Inital DB already loaded");
            return;
        }
        LOG.debug("Loading inital DB data...");
        for (DBLoader loader : this.dbloader) {
            loader.load();
            LOG.info("Inital DB data loaded for " + loader.getName());
        }
    }

    protected boolean isDBEmpty() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        cq.select((Selection)cb.count((Expression)cq.from(ClaimEntity.class)));
        return (Long)this.em.createQuery(cq).getSingleResult() == 0L;
    }
}

