/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.rest.IdpService;
import org.apache.cxf.fediz.service.idp.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class ConfigServiceJPA
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigServiceJPA.class);
    IdpService idpService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Idp getIDP(String realm) {
        Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
            if (realm == null || realm.length() == 0) {
                authorities.add(new SimpleGrantedAuthority("IDP_LIST"));
                UsernamePasswordAuthenticationToken technicalUser = new UsernamePasswordAuthenticationToken((Object)"IDP_TEST", (Object)"N.A", authorities);
                SecurityContextHolder.getContext().setAuthentication((Authentication)technicalUser);
                Idp idp = (Idp)this.idpService.getIdps(0, 1, Arrays.asList("all"), null).getIdps().iterator().next();
                return idp;
            }
            authorities.add(new SimpleGrantedAuthority("IDP_READ"));
            UsernamePasswordAuthenticationToken technicalUser = new UsernamePasswordAuthenticationToken((Object)"IDP_TEST", (Object)"N.A", authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)technicalUser);
            Idp idp = this.idpService.getIdp(realm, Arrays.asList("all"));
            return idp;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
            LOG.info("Old Spring security context restored");
        }
    }

    public void setIDP(Idp config) {
    }

    public void removeIDP(String realm) {
    }

    public IdpService getIdpService() {
        return this.idpService;
    }

    public void setIdpService(IdpService idpService) {
        this.idpService = idpService;
    }
}

