/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.RequestClaim;
import org.apache.cxf.fediz.service.idp.service.ApplicationDAO;
import org.apache.cxf.fediz.service.idp.service.ClaimDAO;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationClaimEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimDAOJPAImpl;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Transactional
public class ApplicationDAOJPAImpl
implements ApplicationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDAOJPAImpl.class);
    private EntityManager em;
    @Autowired
    private ClaimDAO claimDAO;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<Application> getApplications(int start, int size, List<String> expandList) {
        ArrayList<Application> list = new ArrayList<Application>();
        Query query = null;
        query = this.em.createQuery("select a from Application a");
        List serviceEntities = query.setFirstResult(start).setMaxResults(size).getResultList();
        for (Object obj : serviceEntities) {
            ApplicationEntity entity = (ApplicationEntity)obj;
            list.add(ApplicationDAOJPAImpl.entity2domain((ApplicationEntity)entity, expandList));
        }
        return list;
    }

    public Application getApplication(String realm, List<String> expandList) {
        return ApplicationDAOJPAImpl.entity2domain((ApplicationEntity)ApplicationDAOJPAImpl.getApplicationEntity((String)realm, (EntityManager)this.em), expandList);
    }

    public Application addApplication(Application application) {
        ApplicationEntity entity = new ApplicationEntity();
        ApplicationDAOJPAImpl.domain2entity((Application)application, (ApplicationEntity)entity);
        this.em.persist((Object)entity);
        LOG.debug("Application '{}' added", (Object)application.getRealm());
        return ApplicationDAOJPAImpl.entity2domain((ApplicationEntity)entity, Arrays.asList("all"));
    }

    public void updateApplication(String realm, Application application) {
        Query query = null;
        query = this.em.createQuery("select a from Application a where a.realm=:realm");
        query.setParameter("realm", (Object)realm);
        ApplicationEntity applicationEntity = (ApplicationEntity)query.getSingleResult();
        ApplicationDAOJPAImpl.domain2entity((Application)application, (ApplicationEntity)applicationEntity);
        this.em.persist((Object)applicationEntity);
        LOG.debug("Application '{}' updated", (Object)realm);
    }

    public void deleteApplication(String realm) {
        Query query = null;
        query = this.em.createQuery("select a from Application a where a.realm=:realm");
        query.setParameter("realm", (Object)realm);
        Object applObj = query.getSingleResult();
        this.em.remove(applObj);
        LOG.debug("Application '{}' deleted", (Object)realm);
    }

    public void addClaimToApplication(Application application, RequestClaim claim) {
        ApplicationEntity applicationEntity = null;
        if (application.getId() != 0) {
            applicationEntity = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)application.getId());
        } else {
            Query query = null;
            query = this.em.createQuery("select a from Application a where a.realm=:realm");
            query.setParameter("realm", (Object)application.getRealm());
            applicationEntity = (ApplicationEntity)query.getSingleResult();
        }
        Claim c = this.claimDAO.getClaim(claim.getClaimType().toString());
        ClaimEntity claimEntity = (ClaimEntity)this.em.find(ClaimEntity.class, (Object)c.getId());
        ApplicationClaimEntity appClaimEntity = new ApplicationClaimEntity();
        appClaimEntity.setClaim(claimEntity);
        appClaimEntity.setApplication(applicationEntity);
        appClaimEntity.setOptional(claim.isOptional());
        applicationEntity.getRequestedClaims().add(appClaimEntity);
    }

    public void removeClaimFromApplication(Application application, RequestClaim claim) {
        ApplicationEntity applicationEntity = null;
        if (application.getId() != 0) {
            applicationEntity = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)application.getId());
        } else {
            Query query = null;
            query = this.em.createQuery("select a from Application a where a.realm=:realm");
            query.setParameter("realm", (Object)application.getRealm());
            applicationEntity = (ApplicationEntity)query.getSingleResult();
        }
        ApplicationClaimEntity foundEntity = null;
        for (ApplicationClaimEntity acm : applicationEntity.getRequestedClaims()) {
            if (!claim.getClaimType().toString().equals(acm.getClaim().getClaimType())) continue;
            foundEntity = acm;
            break;
        }
        if (foundEntity == null) {
            throw new EntityNotFoundException("ApplicationClaimEntity not found");
        }
        applicationEntity.getRequestedClaims().remove(foundEntity);
    }

    static ApplicationEntity getApplicationEntity(String realm, EntityManager em) {
        Query query = null;
        query = em.createQuery("select a from Application a where a.realm=:realm");
        query.setParameter("realm", (Object)realm);
        return (ApplicationEntity)query.getSingleResult();
    }

    public static void domain2entity(Application application, ApplicationEntity entity) {
        if (application.getId() > 0) {
            entity.setId(application.getId());
        }
        entity.setEncryptionCertificate(application.getEncryptionCertificate());
        entity.setLifeTime(application.getLifeTime());
        entity.setProtocol(application.getProtocol());
        entity.setRealm(application.getRealm());
        entity.setRole(application.getRole());
        entity.setServiceDescription(application.getServiceDescription());
        entity.setServiceDisplayName(application.getServiceDisplayName());
        entity.setTokenType(application.getTokenType());
        entity.setPolicyNamespace(application.getPolicyNamespace());
        entity.setPassiveRequestorEndpoint(application.getPassiveRequestorEndpoint());
    }

    public static Application entity2domain(ApplicationEntity entity, List<String> expandList) {
        Application application = new Application();
        application.setId(entity.getId());
        application.setEncryptionCertificate(entity.getEncryptionCertificate());
        application.setLifeTime(entity.getLifeTime());
        application.setProtocol(entity.getProtocol());
        application.setRealm(entity.getRealm());
        application.setRole(entity.getRole());
        application.setServiceDescription(entity.getServiceDescription());
        application.setServiceDisplayName(entity.getServiceDisplayName());
        application.setTokenType(entity.getTokenType());
        application.setPolicyNamespace(entity.getPolicyNamespace());
        application.setPassiveRequestorEndpoint(entity.getPassiveRequestorEndpoint());
        if (expandList != null && (expandList.contains("all") || expandList.contains("claims"))) {
            for (ApplicationClaimEntity item : entity.getRequestedClaims()) {
                RequestClaim claim = ApplicationDAOJPAImpl.entity2domain((ApplicationClaimEntity)item);
                application.getRequestedClaims().add(claim);
            }
        }
        return application;
    }

    public static RequestClaim entity2domain(ApplicationClaimEntity entity) {
        Claim claim = ClaimDAOJPAImpl.entity2domain((ClaimEntity)entity.getClaim());
        RequestClaim reqClaim = new RequestClaim(claim);
        reqClaim.setId(entity.getId());
        reqClaim.setOptional(entity.isOptional());
        return reqClaim;
    }

    public static void domain2entity(ApplicationEntity application, RequestClaim reqClaim, ApplicationClaimEntity entity) {
        ClaimEntity claim = new ClaimEntity();
        ClaimDAOJPAImpl.domain2entity((Claim)reqClaim, (ClaimEntity)claim);
        entity.setApplication(application);
        entity.setClaim(claim);
        entity.setOptional(reqClaim.isOptional());
    }
}

