/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.rest.IdpService;
import org.apache.cxf.fediz.service.idp.rest.Idps;
import org.apache.cxf.fediz.service.idp.service.ApplicationDAO;
import org.apache.cxf.fediz.service.idp.service.ClaimDAO;
import org.apache.cxf.fediz.service.idp.service.IdpDAO;
import org.apache.cxf.fediz.service.idp.service.TrustedIdpDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdpServiceImpl
implements IdpService {
    private static final Logger LOG = LoggerFactory.getLogger(IdpServiceImpl.class);
    @Autowired
    private IdpDAO idpDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private TrustedIdpDAO trustedIdpDAO;
    @Autowired
    private ClaimDAO claimDAO;

    public Idps getIdps(int start, int size, List<String> expand, UriInfo uriInfo) {
        List idps = this.idpDAO.getIdps(start, size, expand);
        Idps list = new Idps();
        list.setIdps((Collection)idps);
        return list;
    }

    public Idp getIdp(String realm, List<String> expand) {
        Idp idp = this.idpDAO.getIdp(realm, expand);
        if (idp == null) {
            throw new NotFoundException();
        }
        return idp;
    }

    public Response addIdp(UriInfo ui, Idp idp) {
        LOG.info("add IDP config");
        if (idp.getApplications() != null && idp.getApplications().size() > 0) {
            LOG.warn("IDP resource contains sub resource 'applications'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (idp.getTrustedIdps() != null && idp.getTrustedIdps().size() > 0) {
            LOG.warn("IDP resource contains sub resource 'trusted-idps'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Idp createdIdp = this.idpDAO.addIdp(idp);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdIdp.getRealm()});
        return Response.created((URI)location).entity((Object)idp).build();
    }

    public Response updateIdp(UriInfo ui, String realm, Idp idp) {
        if (!realm.equals(idp.getRealm().toString())) {
            throw new BadRequestException();
        }
        if (idp.getApplications() != null && idp.getApplications().size() > 0) {
            LOG.warn("IDP resource contains sub resource 'applications'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (idp.getTrustedIdps() != null && idp.getTrustedIdps().size() > 0) {
            LOG.warn("IDP resource contains sub resource 'trusted-idps'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.idpDAO.updateIdp(realm, idp);
        return Response.noContent().build();
    }

    public Response deleteIdp(String realm) {
        this.idpDAO.deleteIdp(realm);
        return Response.noContent().build();
    }

    public Response addApplicationToIdp(UriInfo ui, String realm, Application application) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        if (idp.getApplications().contains(application.getRealm())) {
            LOG.warn("Application '" + application.getRealm() + "' already added");
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        Application application2 = this.applicationDAO.getApplication(application.getRealm(), null);
        this.idpDAO.addApplicationToIdp(idp, application2);
        return Response.noContent().build();
    }

    public Response removeApplicationFromIdp(UriInfo ui, String realm, String applicationRealm) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        Application foundItem = null;
        for (Application item : idp.getApplications()) {
            if (!item.getRealm().equals(applicationRealm)) continue;
            foundItem = item;
            break;
        }
        if (foundItem == null) {
            LOG.warn("Application '" + applicationRealm + "' not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.idpDAO.removeApplicationFromIdp(idp, foundItem);
        return Response.noContent().build();
    }

    public Response addTrustedIdpToIdp(UriInfo ui, String realm, TrustedIdp trustedIdp) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        if (idp.getTrustedIdps().contains(trustedIdp.getRealm())) {
            LOG.warn("Trusted IDP '" + trustedIdp.getRealm() + "' already added");
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        TrustedIdp trustedIpd2 = this.trustedIdpDAO.getTrustedIDP(trustedIdp.getRealm());
        this.idpDAO.addTrustedIdpToIdp(idp, trustedIpd2);
        return Response.noContent().build();
    }

    public Response removeTrustedIdpFromIdp(UriInfo ui, String realm, String trustedIdpRealm) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        TrustedIdp foundItem = null;
        for (TrustedIdp item : idp.getTrustedIdps()) {
            if (!item.getRealm().equals(trustedIdpRealm)) continue;
            foundItem = item;
            break;
        }
        if (foundItem == null) {
            LOG.warn("Trusted IDP '" + trustedIdpRealm + "' not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.idpDAO.removeTrustedIdpFromIdp(idp, foundItem);
        return Response.noContent().build();
    }

    public Response addClaimToIdp(UriInfo ui, String realm, Claim claim) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        if (idp.getClaimTypesOffered().contains(claim.getClaimType().toString())) {
            LOG.warn("Claim '" + claim.getClaimType() + "' already added");
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        Claim claim2 = this.claimDAO.getClaim(claim.getClaimType().toString());
        this.idpDAO.addClaimToIdp(idp, claim2);
        return Response.noContent().build();
    }

    public Response removeClaimFromIdp(UriInfo ui, String realm, String claimType) {
        Idp idp = this.idpDAO.getIdp(realm, Arrays.asList("all"));
        Claim foundItem = null;
        for (Claim item : idp.getClaimTypesOffered()) {
            if (!item.getClaimType().toString().equals(claimType)) continue;
            foundItem = item;
            break;
        }
        if (foundItem == null) {
            LOG.warn("Claim '" + claimType + "' not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.idpDAO.removeClaimFromIdp(idp, foundItem);
        return Response.noContent().build();
    }
}

