/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.rest.Idps;
import org.springframework.security.access.prepost.PreAuthorize;

@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="idps")
public interface IdpService {
    @GET
    @PreAuthorize(value="hasRole('IDP_LIST')")
    public Idps getIdps(@QueryParam(value="start") int var1, @QueryParam(value="size") @DefaultValue(value="2") int var2, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var3, @Context UriInfo var4);

    @GET
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('IDP_READ')")
    public Idp getIdp(@PathParam(value="realm") String var1, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var2);

    @POST
    @PreAuthorize(value="hasRole('IDP_CREATE')")
    public Response addIdp(@Context UriInfo var1, Idp var2);

    @PUT
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response updateIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, Idp var3);

    @DELETE
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('IDP_DELETE')")
    public Response deleteIdp(@PathParam(value="realm") String var1);

    @POST
    @Path(value="{realm}/applications")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response addApplicationToIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, Application var3);

    @DELETE
    @Path(value="{realm}/applications/{realmApplication}")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response removeApplicationFromIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, @PathParam(value="realmApplication") String var3);

    @POST
    @Path(value="{realm}/trusted-idps")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response addTrustedIdpToIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, TrustedIdp var3);

    @DELETE
    @Path(value="{realm}/trusted-idps/{realmTrustedIdp}")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response removeTrustedIdpFromIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, @PathParam(value="realmTrustedIdp") String var3);

    @POST
    @Path(value="{realm}/claims")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response addClaimToIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, Claim var3);

    @DELETE
    @Path(value="{realm}/claims/{claimType}")
    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public Response removeClaimFromIdp(@Context UriInfo var1, @PathParam(value="realm") String var2, @PathParam(value="claimType") String var3);
}

