/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Entitlement;
import org.apache.cxf.fediz.service.idp.rest.EntitlementService;
import org.apache.cxf.fediz.service.idp.rest.Entitlements;
import org.apache.cxf.fediz.service.idp.service.EntitlementDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntitlementServiceImpl
implements EntitlementService {
    private static final Logger LOG = LoggerFactory.getLogger(EntitlementServiceImpl.class);
    @Autowired
    private EntitlementDAO entitlementDAO;

    public Entitlements getEntitlements(int start, int size, UriInfo uriInfo) {
        List entitlements = this.entitlementDAO.getEntitlements(start, size);
        Entitlements list = new Entitlements();
        list.setEntitlements((Collection)entitlements);
        return list;
    }

    public Response addEntitlement(UriInfo ui, Entitlement entitlement) {
        Entitlement createdEntitlement = this.entitlementDAO.addEntitlement(entitlement);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdEntitlement.getName()});
        LOG.debug("Entitlement '" + createdEntitlement.getName() + "' added");
        return Response.created((URI)location).entity((Object)entitlement).build();
    }

    public Entitlement getEntitlement(String name) {
        Entitlement entitlement = this.entitlementDAO.getEntitlement(name);
        if (entitlement == null) {
            throw new NotFoundException();
        }
        return entitlement;
    }

    public Response updateEntitlement(UriInfo ui, String name, Entitlement entitlement) {
        if (!name.equals(entitlement.getName())) {
            throw new BadRequestException();
        }
        this.entitlementDAO.updateEntitlement(name, entitlement);
        LOG.debug("Entitlement '" + entitlement.getName() + "' updated");
        return Response.noContent().build();
    }

    public Response deleteEntitlement(String name) {
        this.entitlementDAO.deleteEntitlement(name);
        LOG.debug("Entitlement '" + name + "' deleted");
        return Response.noContent().build();
    }
}

