/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.rest.ClaimService;
import org.apache.cxf.fediz.service.idp.rest.Claims;
import org.apache.cxf.fediz.service.idp.service.ClaimDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClaimServiceImpl
implements ClaimService {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimServiceImpl.class);
    @Autowired
    private ClaimDAO claimDAO;

    public Response getClaims(int start, int size, UriInfo uriInfo) {
        List claims = this.claimDAO.getClaims(start, size);
        for (Claim c : claims) {
            URI self = uriInfo.getAbsolutePathBuilder().path(c.getClaimType().toString()).build(new Object[0]);
            c.setHref(self);
        }
        Claims list = new Claims();
        list.setClaims((Collection)claims);
        return Response.ok((Object)list).build();
    }

    public Response addClaim(UriInfo ui, Claim claim) {
        LOG.info("add Claim config");
        Claim createdClaim = this.claimDAO.addClaim(claim);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdClaim.getClaimType().toString()});
        return Response.created((URI)location).entity((Object)claim).build();
    }

    public Claim getClaim(String claimType) {
        Claim claim = this.claimDAO.getClaim(claimType);
        if (claim == null) {
            throw new NotFoundException();
        }
        return claim;
    }

    public Response updateClaim(UriInfo ui, String claimType, Claim claim) {
        if (!claimType.equals(claim.getClaimType().toString())) {
            throw new BadRequestException();
        }
        this.claimDAO.updateClaim(claimType, claim);
        return Response.noContent().build();
    }

    public Response deleteClaim(String claimType) {
        this.claimDAO.deleteClaim(claimType);
        return Response.noContent().build();
    }
}

