/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.RequestClaim;
import org.apache.cxf.fediz.service.idp.rest.ApplicationService;
import org.apache.cxf.fediz.service.idp.rest.Applications;
import org.apache.cxf.fediz.service.idp.service.ApplicationDAO;
import org.apache.cxf.fediz.service.idp.service.ClaimDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationServiceImpl
implements ApplicationService {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private ClaimDAO claimDAO;

    public Applications getApplications(int start, int size, List<String> expand, UriInfo uriInfo) {
        List applications = this.applicationDAO.getApplications(start, size, expand);
        for (Application a : applications) {
            URI self = uriInfo.getAbsolutePathBuilder().path(a.getRealm()).build(new Object[0]);
            a.setHref(self);
        }
        Applications list = new Applications();
        list.setApplications((Collection)applications);
        return list;
    }

    public Application getApplication(String realm, List<String> expand) {
        Application application = this.applicationDAO.getApplication(realm, expand);
        if (application == null) {
            throw new NotFoundException();
        }
        return application;
    }

    public Response addApplication(UriInfo ui, Application application) {
        LOG.info("add Service config");
        if (application.getRequestedClaims() != null && application.getRequestedClaims().size() > 0) {
            LOG.warn("Application resource contains sub resource 'claims'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Application createdApplication = this.applicationDAO.addApplication(application);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdApplication.getRealm()});
        return Response.created((URI)location).entity((Object)application).build();
    }

    public Response updateApplication(UriInfo ui, String realm, Application application) {
        if (!realm.equals(application.getRealm().toString())) {
            throw new BadRequestException();
        }
        if (application.getRequestedClaims() != null && application.getRequestedClaims().size() > 0) {
            LOG.warn("Application resource contains sub resource 'claims'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.applicationDAO.updateApplication(realm, application);
        return Response.noContent().build();
    }

    public Response deleteApplication(String realm) {
        this.applicationDAO.deleteApplication(realm);
        return Response.noContent().build();
    }

    public Response addClaimToApplication(UriInfo ui, String realm, RequestClaim claim) {
        Application application = this.applicationDAO.getApplication(realm, null);
        if (application.getRequestedClaims().contains(claim)) {
            LOG.warn("Claim '" + claim.getClaimType() + "' already added");
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        Claim foundClaim = this.claimDAO.getClaim(claim.getClaimType().toString());
        RequestClaim rc = new RequestClaim(foundClaim);
        application.getRequestedClaims().add(rc);
        this.applicationDAO.addClaimToApplication(application, claim);
        return Response.noContent().build();
    }

    public Response removeClaimFromApplication(UriInfo ui, String realm, String claimType) {
        Application application = this.applicationDAO.getApplication(realm, null);
        RequestClaim foundItem = null;
        for (RequestClaim item : application.getRequestedClaims()) {
            if (!item.getClaimType().toString().equals(claimType)) continue;
            foundItem = item;
            break;
        }
        if (foundItem == null) {
            LOG.warn("Claim '" + claimType + "' not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        application.getRequestedClaims().remove(foundItem);
        this.applicationDAO.removeClaimFromApplication(application, foundItem);
        return Response.noContent().build();
    }
}

