/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.RequestClaim;
import org.apache.cxf.fediz.service.idp.rest.Applications;
import org.springframework.security.access.prepost.PreAuthorize;

@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="applications")
public interface ApplicationService {
    @GET
    @PreAuthorize(value="hasRole('APPLICATION_LIST')")
    public Applications getApplications(@QueryParam(value="start") int var1, @QueryParam(value="size") @DefaultValue(value="2") int var2, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var3, @Context UriInfo var4);

    @GET
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('APPLICATION_LIST')")
    public Application getApplication(@PathParam(value="realm") String var1, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var2);

    @POST
    @PreAuthorize(value="hasRole('APPLICATION_CREATE')")
    public Response addApplication(@Context UriInfo var1, Application var2);

    @PUT
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('APPLICATION_UPDATE')")
    public Response updateApplication(@Context UriInfo var1, @PathParam(value="realm") String var2, Application var3);

    @DELETE
    @Path(value="{realm}")
    @PreAuthorize(value="hasRole('APPLICATION_DELETE')")
    public Response deleteApplication(@PathParam(value="realm") String var1);

    @POST
    @Path(value="{realm}/claims")
    @PreAuthorize(value="hasRole('APPLICATION_UPDATE')")
    public Response addClaimToApplication(@Context UriInfo var1, @PathParam(value="realm") String var2, RequestClaim var3);

    @DELETE
    @Path(value="{realm}/claims/{claimType}")
    @PreAuthorize(value="hasRole('APPLICATION_UPDATE')")
    public Response removeClaimFromApplication(@Context UriInfo var1, @PathParam(value="realm") String var2, @PathParam(value="claimType") String var3);
}

