/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.spi.TrustedIdpProtocolHandler;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AuthnRequestBuilder;
import org.apache.cxf.rs.security.saml.sso.DefaultAuthnRequestBuilder;
import org.apache.cxf.rs.security.saml.sso.SAMLProtocolResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SAMLSSOResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class TrustedIdpSAMLProtocolHandler
implements TrustedIdpProtocolHandler {
    public static final String SIGN_REQUEST = "sign.request";
    public static final String REQUIRE_KEYINFO = "require.keyinfo";
    public static final String REQUIRE_SIGNED_ASSERTIONS = "require.signed.assertions";
    public static final String REQUIRE_KNOWN_ISSUER = "require.known.issuer";
    public static final String SUPPORT_BASE64_ENCODING = "support.base64.encoding";
    public static final String SUPPORT_DEFLATE_ENCODING = "support.deflate.encoding";
    public static final String PROTOCOL = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpSAMLProtocolHandler.class);
    private static final String SAML_SSO_REQUEST_ID = "saml-sso-request-id";
    private AuthnRequestBuilder authnRequestBuilder = new DefaultAuthnRequestBuilder();

    public boolean canHandleRequest(HttpServletRequest request) {
        return false;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public URL mapSignInRequest(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        try {
            Document doc = DOMUtils.createDocument();
            doc.appendChild(doc.createElement("root"));
            AuthnRequest authnRequest = this.authnRequestBuilder.createAuthnRequest(null, idp.getRealm(), idp.getIdpUrl().toString());
            boolean signRequest = this.isPropertyConfigured(trustedIdp, SIGN_REQUEST, true);
            if (signRequest) {
                authnRequest.setDestination(trustedIdp.getUrl());
            }
            Element authnRequestElement = OpenSAMLUtil.toDom((XMLObject)authnRequest, (Document)doc);
            String authnRequestEncoded = this.encodeAuthnRequest(authnRequestElement);
            String urlEncodedRequest = URLEncoder.encode(authnRequestEncoded, "UTF-8");
            UriBuilder ub = UriBuilder.fromUri((String)trustedIdp.getUrl());
            ub.queryParam("SAMLRequest", new Object[]{urlEncodedRequest});
            String wctx = context.getFlowScope().getString("wctx");
            if (wctx != null) {
                ub.queryParam("RelayState", new Object[]{wctx});
            }
            if (signRequest) {
                this.signRequest(urlEncodedRequest, wctx, idp, ub);
            }
            String authnRequestId = authnRequest.getID();
            WebUtils.putAttributeInExternalContext((RequestContext)context, (String)SAML_SSO_REQUEST_ID, (Object)authnRequestId);
            HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
            response.addHeader("Cache-Control", "no-cache, no-store");
            response.addHeader("Pragma", "no-cache");
            return ub.build(new Object[0]).toURL();
        }
        catch (MalformedURLException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
        catch (Exception ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
    }

    public SecurityToken mapSignInResponse(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        try {
            String encodedSAMLResponse = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"SAMLResponse");
            Response samlResponse = this.readSAMLResponse(encodedSAMLResponse, trustedIdp);
            Crypto crypto = this.getCrypto(trustedIdp.getCertificate());
            this.validateSamlResponseProtocol(samlResponse, crypto, trustedIdp);
            SSOValidatorResponse validatorResponse = this.validateSamlSSOResponse(samlResponse, idp, trustedIdp, context);
            String id = IDGenerator.generateID((String)"_");
            SecurityToken idpToken = new SecurityToken(id, validatorResponse.getCreated(), validatorResponse.getSessionNotOnOrAfter());
            idpToken.setToken(validatorResponse.getAssertionElement());
            String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
            LOG.info("[IDP_TOKEN={}] created from [RP_TOKEN={}] issued by home realm [{}]", new Object[]{id, validatorResponse.getResponseId(), whr});
            LOG.debug("Created date={}", (Object)validatorResponse.getCreated());
            LOG.debug("Expired date={}", (Object)validatorResponse.getSessionNotOnOrAfter());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validated: " + System.getProperty("line.separator") + validatorResponse.getAssertion());
            }
            return idpToken;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn("Unexpected exception occured", (Throwable)ex);
            throw new IllegalStateException("Unexpected exception occured: " + ex.getMessage());
        }
    }

    private String encodeAuthnRequest(Element authnRequest) throws IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug(requestMessage);
        }
        DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
        byte[] deflatedBytes = encoder.deflateToken(requestMessage.getBytes("UTF-8"));
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    private void signRequest(String authnRequest, String relayState, Idp config, UriBuilder ub) throws Exception {
        Crypto crypto = this.getCrypto(config.getCertificate());
        if (crypto == null) {
            LOG.error("No crypto instance of properties file configured for signature");
            throw new IllegalStateException("Invalid IdP configuration");
        }
        String alias = crypto.getDefaultX509Identifier();
        X509Certificate cert = CertsUtils.getX509Certificate((Crypto)crypto, (String)alias);
        if (cert == null) {
            LOG.error("No cert was found to sign the request using alias: " + alias);
            throw new IllegalStateException("Invalid IdP configuration");
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String pubKeyAlgo = cert.getPublicKey().getAlgorithm();
        String jceSigAlgo = "SHA1withRSA";
        LOG.debug("automatic sig algo detection: " + pubKeyAlgo);
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            jceSigAlgo = "SHA1withDSA";
        }
        LOG.debug("Using Signature algorithm " + sigAlgo);
        ub.queryParam("SigAlg", new Object[]{URLEncoder.encode(sigAlgo, "UTF-8")});
        String password = config.getCertificatePassword();
        PrivateKey privateKey = crypto.getPrivateKey(alias, password);
        Signature signature = Signature.getInstance(jceSigAlgo);
        signature.initSign(privateKey);
        String requestToSign = "SAMLRequest=" + authnRequest + "&" + "RelayState" + "=" + relayState + "&" + "SigAlg" + "=" + URLEncoder.encode(sigAlgo, "UTF-8");
        signature.update(requestToSign.getBytes("UTF-8"));
        byte[] signBytes = signature.sign();
        String encodedSignature = Base64.encode((byte[])signBytes);
        ub.queryParam("Signature", new Object[]{URLEncoder.encode(encodedSignature, "UTF-8")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getCrypto(String certificate) throws ProcessingException {
        if (certificate == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = Merlin.loadInputStream((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)certificate);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
            CertificateStore certificateStore = new CertificateStore(new X509Certificate[]{cert});
            return certificateStore;
        }
        catch (WSSecurityException ex) {
            LOG.error("Failed to load keystore " + certificate, (Throwable)ex);
            throw new RuntimeException("Failed to load keystore " + certificate);
        }
        catch (IOException ex) {
            LOG.error("Failed to read keystore", (Throwable)ex);
            throw new RuntimeException("Failed to read keystore");
        }
        catch (CertificateException ex) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return CertsUtils.createCrypto((String)certificate);
    }

    private Response readSAMLResponse(String samlResponse, TrustedIdp trustedIdp) {
        if (StringUtils.isEmpty((String)samlResponse)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        String samlResponseDecoded = samlResponse;
        ByteArrayInputStream tokenStream = null;
        if (this.isPropertyConfigured(trustedIdp, SUPPORT_BASE64_ENCODING, true)) {
            try {
                byte[] deflatedToken = Base64Utility.decode((String)samlResponseDecoded);
                tokenStream = this.isPropertyConfigured(trustedIdp, SUPPORT_DEFLATE_ENCODING, false) ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
            }
            catch (Base64Exception ex) {
                throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
            }
            catch (DataFormatException ex) {
                throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
            }
        }
        try {
            tokenStream = new ByteArrayInputStream(samlResponseDecoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
        }
        Document responseDoc = null;
        try {
            responseDoc = StaxUtils.read((Reader)new InputStreamReader((InputStream)tokenStream, "UTF-8"));
        }
        catch (Exception ex) {
            throw new WebApplicationException(400);
        }
        LOG.debug("Received response: " + DOM2Writer.nodeToString((Node)responseDoc.getDocumentElement()));
        XMLObject responseObject = null;
        try {
            responseObject = OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        }
        catch (WSSecurityException ex) {
            throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
        }
        if (!(responseObject instanceof Response)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        return (Response)responseObject;
    }

    private void validateSamlResponseProtocol(Response samlResponse, Crypto crypto, TrustedIdp trustedIdp) {
        try {
            SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
            protocolValidator.setKeyInfoMustBeAvailable(this.isPropertyConfigured(trustedIdp, REQUIRE_KNOWN_ISSUER, true));
            protocolValidator.validateSamlResponse(samlResponse, crypto, null);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }

    private SSOValidatorResponse validateSamlSSOResponse(Response samlResponse, Idp idp, TrustedIdp trustedIdp, RequestContext requestContext) {
        try {
            SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
            ssoResponseValidator.setAssertionConsumerURL(idp.getIdpUrl().toString());
            HttpServletRequest servletRequest = WebUtils.getHttpServletRequest((RequestContext)requestContext);
            ssoResponseValidator.setClientAddress(servletRequest.getRemoteAddr());
            ssoResponseValidator.setIssuerIDP(trustedIdp.getUrl());
            String requestId = (String)WebUtils.getAttributeFromExternalContext((RequestContext)requestContext, (String)SAML_SSO_REQUEST_ID);
            ssoResponseValidator.setRequestId(requestId);
            ssoResponseValidator.setSpIdentifier(idp.getRealm());
            ssoResponseValidator.setEnforceAssertionsSigned(this.isPropertyConfigured(trustedIdp, REQUIRE_SIGNED_ASSERTIONS, true));
            ssoResponseValidator.setEnforceKnownIssuer(this.isPropertyConfigured(trustedIdp, REQUIRE_KNOWN_ISSUER, true));
            return ssoResponseValidator.validateSamlResponse(samlResponse, false);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
        }
    }

    private boolean isPropertyConfigured(TrustedIdp trustedIdp, String property, boolean defaultValue) {
        Map parameters = trustedIdp.getParameters();
        if (parameters != null && parameters.containsKey(property)) {
            return Boolean.parseBoolean((String)parameters.get(property));
        }
        return defaultValue;
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

