/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.kerberos;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.fediz.service.idp.kerberos.KerberosServiceRequestToken;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.apache.wss4j.common.kerberos.KerberosServiceExceptionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosTokenValidator.class);
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String contextName;
    private boolean usernameServiceNameForm;
    private boolean spnego;

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public KerberosServiceContext validate(KerberosServiceRequestToken token) throws LoginException, PrivilegedActionException {
        if (LOG.isDebugEnabled()) {
            try {
                String jaasAuth = System.getProperty("java.security.auth.login.config");
                String krbConf = System.getProperty("java.security.krb5.conf");
                LOG.debug("KerberosTokenValidator - Using JAAS auth login file: " + jaasAuth);
                LOG.debug("KerberosTokenValidator - Using KRB conf file: " + krbConf);
            }
            catch (SecurityException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        LoginContext loginContext = null;
        loginContext = this.callbackHandler != null ? new LoginContext(this.getContextName(), this.callbackHandler) : new LoginContext(this.getContextName());
        loginContext.login();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully authenticated to the TGT");
        }
        Subject subject = loginContext.getSubject();
        String service = this.serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                LOG.debug("No Client principals found after login");
                return null;
            }
            service = principals.iterator().next().getName();
        }
        KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(token.getToken(), service, this.isUsernameServiceNameForm(), this.spnego);
        KerberosServiceContext krbServiceCtx = (KerberosServiceContext)Subject.doAs(subject, action);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully validated a ticket");
        }
        return krbServiceCtx;
    }

    public boolean isUsernameServiceNameForm() {
        return this.usernameServiceNameForm;
    }

    public void setUsernameServiceNameForm(boolean isUsernameServiceNameForm) {
        this.usernameServiceNameForm = isUsernameServiceNameForm;
    }

    public boolean isSpnego() {
        return this.spnego;
    }

    public void setSpnego(boolean spnego) {
        this.spnego = spnego;
    }
}

