/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.util.Date;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class WfreshParser {
    private static final Logger LOG = LoggerFactory.getLogger(WfreshParser.class);

    public boolean authenticationRequired(String wfresh, String whr, RequestContext context) throws Exception {
        long ttl;
        SecurityToken idpToken = (SecurityToken)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)whr);
        if (idpToken.isExpired()) {
            LOG.info("[IDP_TOKEN=" + idpToken.getId() + "] is expired.");
            return true;
        }
        if (wfresh == null || wfresh.trim().isEmpty()) {
            return false;
        }
        try {
            ttl = Long.parseLong(wfresh.trim());
        }
        catch (Exception e) {
            LOG.info("wfresh value '" + wfresh + "' is invalid.");
            return false;
        }
        if (ttl == 0L) {
            return true;
        }
        if (ttl > 0L) {
            Date createdDate = idpToken.getCreated();
            if (createdDate != null) {
                Date expiryDate = new Date();
                expiryDate.setTime(createdDate.getTime() + ttl * 60L * 1000L);
                if (expiryDate.before(new Date())) {
                    LOG.info("[IDP_TOKEN=" + idpToken.getId() + "] is valid but relying party requested new authentication caused by wfresh=" + wfresh + " outdated.");
                    return true;
                }
            } else {
                LOG.info("token creation date not set. Unable to check wfresh is outdated.");
            }
        } else {
            LOG.info("ttl value '" + ttl + "' is negative.");
        }
        return false;
    }
}

