/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.net.URL;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.protocols.ProtocolController;
import org.apache.cxf.fediz.service.idp.spi.TrustedIdpProtocolHandler;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.execution.RequestContext;

public class TrustedIdpProtocolAction {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpProtocolAction.class);
    private static final String IDP_CONFIG = "idpConfig";
    @Autowired
    @Qualifier(value="trustedIdpProtocolControllerImpl")
    private ProtocolController<TrustedIdpProtocolHandler> trustedIdpProtocolHandlers;

    public String mapSignInRequest(RequestContext requestContext) {
        String trustedIdpRealm = requestContext.getFlowScope().getString("whr");
        LOG.info("Prepare redirect to Trusted IDP '{}'", (Object)trustedIdpRealm);
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)requestContext, (String)IDP_CONFIG);
        TrustedIdp trustedIdp = idpConfig.findTrustedIdp(trustedIdpRealm);
        if (trustedIdp == null) {
            LOG.error("TrustedIdp '{}' not configured", (Object)trustedIdpRealm);
            throw new IllegalStateException("TrustedIdp '" + trustedIdpRealm + "'");
        }
        String protocol = trustedIdp.getProtocol();
        LOG.debug("TrustedIdp '{}' supports protocol {}", (Object)trustedIdpRealm, (Object)protocol);
        TrustedIdpProtocolHandler protocolHandler = (TrustedIdpProtocolHandler)this.trustedIdpProtocolHandlers.getProtocolHandler(protocol);
        if (protocolHandler == null) {
            LOG.error("No ProtocolHandler found for {}", (Object)protocol);
            throw new IllegalStateException("No ProtocolHandler found for '" + protocol + "'");
        }
        URL redirectUrl = protocolHandler.mapSignInRequest(requestContext, idpConfig, trustedIdp);
        LOG.info("Redirect url {}", (Object)redirectUrl.toString());
        return redirectUrl.toString();
    }

    public SecurityToken mapSignInResponse(RequestContext requestContext) {
        String trustedIdpRealm = requestContext.getFlowScope().getString("whr");
        LOG.info("Prepare validate SignInResponse of Trusted IDP '{}'", (Object)trustedIdpRealm);
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)requestContext, (String)IDP_CONFIG);
        TrustedIdp trustedIdp = idpConfig.findTrustedIdp(trustedIdpRealm);
        if (trustedIdp == null) {
            LOG.error("TrustedIdp '{}' not configured", (Object)trustedIdpRealm);
            throw new IllegalStateException("TrustedIdp '" + trustedIdpRealm + "'");
        }
        String protocol = trustedIdp.getProtocol();
        LOG.debug("TrustedIdp '{}' supports protocol {}", (Object)trustedIdpRealm, (Object)protocol);
        TrustedIdpProtocolHandler protocolHandler = (TrustedIdpProtocolHandler)this.trustedIdpProtocolHandlers.getProtocolHandler(protocol);
        if (protocolHandler == null) {
            LOG.error("No ProtocolHandler found for {}", (Object)protocol);
            throw new IllegalStateException("No ProtocolHandler found for '" + protocol + "'");
        }
        SecurityToken token = protocolHandler.mapSignInResponse(requestContext, idpConfig, trustedIdp);
        if (token != null) {
            LOG.info("SignInResponse successfully validated and SecurityToken created");
        }
        return token;
    }
}

