/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class SigninParametersCacheAction {
    public static final String IDP_CONFIG = "idpConfig";
    public static final String REALM_URL_MAP = "realmUrlMap";
    private static final Logger LOG = LoggerFactory.getLogger(SigninParametersCacheAction.class);

    public void store(RequestContext context) {
        HashMap<String, Object> signinParams = new HashMap<String, Object>();
        String uuidKey = UUID.randomUUID().toString();
        Object value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreply");
        if (value != null) {
            signinParams.put("wreply", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wtrealm")) != null) {
            signinParams.put("wtrealm", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr")) != null) {
            signinParams.put("whr", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wctx")) != null) {
            signinParams.put("wctx", value);
        }
        WebUtils.putAttributeInExternalContext((RequestContext)context, (String)uuidKey, signinParams);
        LOG.debug("SignIn parameters cached: {}", (Object)((Object)signinParams).toString());
        WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wctx", (Object)uuidKey);
        LOG.info("SignIn parameters cached and wctx set to [" + uuidKey + "].");
    }

    public void restore(RequestContext context) {
        Map signinParams;
        String uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wctx");
        if (uuidKey == null) {
            uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"RelayState");
        }
        if ((signinParams = (Map)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)uuidKey)) != null) {
            String value = (String)signinParams.get("wreply");
            if (value != null) {
                WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wreply", (Object)value);
            }
            if ((value = (String)signinParams.get("wtrealm")) != null) {
                WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wtrealm", (Object)value);
            }
            if ((value = (String)signinParams.get("whr")) != null) {
                WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"whr", (Object)value);
            }
            LOG.debug("SignIn parameters restored: {}", (Object)signinParams.toString());
            WebUtils.removeAttributeFromFlowScope((RequestContext)context, (String)"wctx");
            LOG.info("SignIn parameters restored and wctx[" + uuidKey + "] cleared.");
            value = (String)signinParams.get("wctx");
            if (value != null) {
                WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wctx", (Object)value);
            }
        } else {
            LOG.debug("Error in restoring security context");
        }
    }

    public void storeRPUrlInSession(RequestContext context) throws ProcessingException {
        String val;
        HashMap<String, String> rum;
        String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
        if (whr == null) {
            return;
        }
        String wtrealm = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wtrealm");
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)IDP_CONFIG);
        String url = null;
        Application serviceConfig = idpConfig.findApplication(wtrealm);
        if (serviceConfig != null) {
            url = serviceConfig.getPassiveRequestorEndpoint();
        }
        if (url == null) {
            url = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreply");
            try {
                new URL(url);
            }
            catch (Exception e) {
                url = null;
            }
            if (url == null) {
                url = wtrealm;
                try {
                    new URL(url);
                }
                catch (Exception e) {
                    throw new ProcessingException(e.getMessage(), (Throwable)e, ProcessingException.TYPE.INVALID_REQUEST);
                }
            }
        }
        if ((rum = (HashMap<String, String>)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)REALM_URL_MAP)) == null) {
            rum = new HashMap<String, String>();
            WebUtils.putAttributeInExternalContext((RequestContext)context, (String)REALM_URL_MAP, rum);
        }
        if ((val = (String)rum.get(wtrealm)) == null) {
            rum.put(wtrealm, url);
        }
    }
}

