/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import org.apache.cxf.fediz.service.idp.STSUserDetails;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;

public class CacheTokenForWauthAction {
    private static final String IDP_CONFIG = "idpConfig";
    private static final Logger LOG = LoggerFactory.getLogger(CacheTokenForWauthAction.class);

    public void submit(RequestContext context) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Assert.isInstanceOf(STSUserDetails.class, (Object)auth.getDetails());
        STSUserDetails stsUserDetails = (STSUserDetails)auth.getDetails();
        SecurityToken securityToken = stsUserDetails.getSecurityToken();
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)IDP_CONFIG);
        WebUtils.putAttributeInExternalContext((RequestContext)context, (String)idpConfig.getRealm(), (Object)securityToken);
        LOG.info("Token [IDP_TOKEN=" + securityToken.getId() + "] for realm [" + idpConfig.getRealm() + "] successfully cached.");
    }
}

