/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.fediz.service.idp.STSAuthenticationProvider;
import org.apache.cxf.fediz.service.idp.STSUserDetails;
import org.apache.cxf.fediz.service.idp.kerberos.KerberosServiceRequestToken;
import org.apache.cxf.fediz.service.idp.kerberos.KerberosTokenValidator;
import org.apache.cxf.fediz.service.idp.kerberos.PassThroughKerberosClient;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class STSKrbAuthenticationProvider
extends STSAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(STSKrbAuthenticationProvider.class);
    private KerberosTokenValidator kerberosTokenValidator;
    private CallbackHandler kerberosCallbackHandler;
    private boolean kerberosUsernameServiceNameForm;
    private boolean requireDelegation;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof KerberosServiceRequestToken)) {
            return null;
        }
        Bus cxfBus = this.getBus();
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        if (this.tokenType != null && this.tokenType.length() > 0) {
            sts.setTokenType(this.tokenType);
        } else {
            sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.wsdlLocation);
        sts.setServiceQName(new QName(this.namespace, this.wsdlService));
        sts.setEndpointQName(new QName(this.namespace, this.wsdlEndpoint));
        sts.getProperties().putAll(this.properties);
        if (this.use200502Namespace) {
            sts.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
        }
        if (this.lifetime != null) {
            sts.setEnableLifetime(true);
            sts.setTtl(this.lifetime.intValue());
        }
        return this.handleKerberos((KerberosServiceRequestToken)authentication, sts);
    }

    private Authentication handleKerberos(KerberosServiceRequestToken kerberosRequestToken, IdpSTSClient sts) {
        Principal kerberosPrincipal = null;
        if (this.requireDelegation) {
            kerberosPrincipal = this.validateKerberosToken(kerberosRequestToken, sts);
            if (kerberosPrincipal == null) {
                return null;
            }
        } else {
            PassThroughKerberosClient kerberosClient = new PassThroughKerberosClient();
            kerberosClient.setToken(kerberosRequestToken.getToken());
            sts.getProperties().put("ws-security.kerberos.client", kerberosClient);
        }
        try {
            SecurityToken token = sts.requestSecurityToken(this.appliesTo);
            if (kerberosPrincipal == null && token.getToken() != null && "Assertion".equals(token.getToken().getLocalName())) {
                kerberosPrincipal = new SAMLTokenPrincipalImpl(new SamlAssertionWrapper(token.getToken()));
            }
            List authorities = this.createAuthorities(token);
            KerberosServiceRequestToken ksrt = new KerberosServiceRequestToken((Object)kerberosPrincipal, (Collection)authorities, kerberosRequestToken.getToken());
            STSUserDetails details = new STSUserDetails(kerberosPrincipal.getName(), "", (Collection)authorities, token);
            ksrt.setDetails((Object)details);
            LOG.debug("[IDP_TOKEN={}] provided for user '{}'", (Object)token.getId(), (Object)kerberosPrincipal.getName());
            return ksrt;
        }
        catch (Exception ex) {
            LOG.info("Failed to authenticate user '" + kerberosRequestToken.getName() + "'", (Throwable)ex);
            return null;
        }
    }

    private Principal validateKerberosToken(KerberosServiceRequestToken token, IdpSTSClient sts) {
        if (this.kerberosTokenValidator == null) {
            LOG.error("KerberosTokenValidator must be configured to support kerberos credential delegation");
            return null;
        }
        Principal kerberosPrincipal = null;
        try {
            KerberosServiceContext kerberosContext = this.kerberosTokenValidator.validate(token);
            if (kerberosContext == null || kerberosContext.getDelegationCredential() == null) {
                LOG.info("Kerberos Validation failure");
                return null;
            }
            GSSCredential delegatedCredential = kerberosContext.getDelegationCredential();
            sts.getProperties().put("ws-security.delegated.credential", delegatedCredential);
            sts.getProperties().put("ws-security.kerberos.use.credential.delegation", "true");
            kerberosPrincipal = kerberosContext.getPrincipal();
        }
        catch (LoginException ex) {
            LOG.info("Failed to authenticate user", (Throwable)ex);
            return null;
        }
        catch (PrivilegedActionException ex) {
            LOG.info("Failed to authenticate user", (Throwable)ex);
            return null;
        }
        if (this.kerberosTokenValidator.getContextName() != null) {
            sts.getProperties().put("ws-security.kerberos.jaas.context", this.kerberosTokenValidator.getContextName());
        }
        if (this.kerberosTokenValidator.getServiceName() != null) {
            sts.getProperties().put("ws-security.kerberos.spn", this.kerberosTokenValidator.getServiceName());
        }
        if (this.kerberosCallbackHandler != null) {
            sts.getProperties().put("ws-security.callback-handler", this.kerberosCallbackHandler);
        }
        if (this.kerberosUsernameServiceNameForm) {
            sts.getProperties().put("ws-security.kerberos.is.username.in.servicename.form", "true");
        }
        return kerberosPrincipal;
    }

    protected GSSContext createGSSContext() throws GSSException {
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSManager gssManager = GSSManager.getInstance();
        String spn = "bob@service.ws.apache.org";
        GSSName gssService = gssManager.createName(spn, null);
        return gssManager.createContext(gssService.canonicalize(oid), oid, null, 0);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(KerberosServiceRequestToken.class);
    }

    public KerberosTokenValidator getKerberosTokenValidator() {
        return this.kerberosTokenValidator;
    }

    public void setKerberosTokenValidator(KerberosTokenValidator kerberosTokenValidator) {
        this.kerberosTokenValidator = kerberosTokenValidator;
    }

    public CallbackHandler getKerberosCallbackHandler() {
        return this.kerberosCallbackHandler;
    }

    public void setKerberosCallbackHandler(CallbackHandler kerberosCallbackHandler) {
        this.kerberosCallbackHandler = kerberosCallbackHandler;
    }

    public boolean isKerberosUsernameServiceNameForm() {
        return this.kerberosUsernameServiceNameForm;
    }

    public void setKerberosUsernameServiceNameForm(boolean kerberosUsernameServiceNameForm) {
        this.kerberosUsernameServiceNameForm = kerberosUsernameServiceNameForm;
    }

    public boolean isRequireDelegation() {
        return this.requireDelegation;
    }

    public void setRequireDelegation(boolean requireDelegation) {
        this.requireDelegation = requireDelegation;
    }
}

