/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimTypes;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.w3c.dom.Element;

public abstract class STSAuthenticationProvider
implements AuthenticationProvider {
    public static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_BEARER = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
    public static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    public static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_02_TRUST = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    private static final Logger LOG = LoggerFactory.getLogger(STSAuthenticationProvider.class);
    protected String wsdlLocation;
    protected String namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    protected String wsdlService;
    protected String wsdlEndpoint;
    protected String appliesTo;
    protected boolean use200502Namespace;
    protected String tokenType;
    protected Bus bus;
    protected Integer lifetime;
    protected String roleURI;
    protected Map<String, Object> properties = new HashMap();

    protected List<GrantedAuthority> createAuthorities(SecurityToken token) throws WSSecurityException {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (this.roleURI != null) {
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(token.getToken());
            List claims = this.parseClaimsInAssertion(assertion.getSaml2());
            for (Claim c : claims) {
                if (!this.roleURI.equals(c.getClaimType())) continue;
                Object oValue = c.getValue();
                if (oValue instanceof List && !((List)oValue).isEmpty()) {
                    List values = (List)oValue;
                    for (Object role : values) {
                        if (!(role instanceof String)) continue;
                        authorities.add((GrantedAuthority)new SimpleGrantedAuthority((String)role));
                    }
                } else {
                    LOG.error("Unsupported value type of Claim value");
                    throw new IllegalStateException("Unsupported value type of Claim value");
                }
                claims.remove(c);
                break;
            }
        }
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_IDP_LOGIN"));
        return authorities;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(String wsdlService) {
        this.wsdlService = wsdlService;
    }

    public String getWsdlEndpoint() {
        return this.wsdlEndpoint;
    }

    public void setWsdlEndpoint(String wsdlEndpoint) {
        this.wsdlEndpoint = wsdlEndpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus != null ? this.bus : BusFactory.getDefaultBus();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            LOG.debug("No attribute statements found");
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap claimsMap = new HashMap();
        for (AttributeStatement statement : attributeStatements) {
            LOG.debug("parsing statement: {}", (Object)statement.getElementQName());
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                LOG.debug("parsing attribute: {}", (Object)attribute.getName());
                Claim c = new Claim();
                URI attrName = URI.create(attribute.getName());
                if (ClaimTypes.URI_BASE.toString().equals(attribute.getNameFormat()) && !attrName.isAbsolute()) {
                    c.setClaimType(URI.create(ClaimTypes.URI_BASE + "/" + attribute.getName()));
                } else {
                    c.setClaimType(URI.create(attribute.getName()));
                }
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    LOG.debug(" [{}]", (Object)value);
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void mergeClaimToMap(Map<String, Claim> claimsMap, Claim c, List<String> valueList) {
        Claim t = claimsMap.get(c.getClaimType().toString());
        if (t != null) {
            Object oValue = t.getValue();
            if (oValue instanceof String) {
                ArrayList<String> values = new ArrayList<String>();
                values.add((String)oValue);
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            if (oValue instanceof List) {
                List values = (List)oValue;
                values.addAll(valueList);
                t.setValue((Object)values);
                return;
            }
            LOG.error("Unsupported value type of Claim value");
            throw new IllegalStateException("Unsupported value type of Claim value");
        }
        if (valueList.size() == 1) {
            c.setValue((Object)valueList.get(0));
        } else {
            c.setValue(valueList);
        }
        claimsMap.put(c.getClaimType().toString(), c);
    }

    public String getRoleURI() {
        return this.roleURI;
    }

    public void setRoleURI(String roleURI) {
        this.roleURI = roleURI;
    }

    public void setProperties(Map<String, Object> p) {
        this.properties.putAll(p);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isUse200502Namespace() {
        return this.use200502Namespace;
    }

    public void setUse200502Namespace(boolean use200502Namespace) {
        this.use200502Namespace = use200502Namespace;
    }
}

