/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.service.ConfigService;
import org.apache.cxf.fediz.service.idp.util.MetadataWriter;
import org.apache.wss4j.common.util.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetadataServlet
extends HttpServlet {
    public static final String PARAM_REALM = "realm";
    private static final Logger LOG = LoggerFactory.getLogger(MetadataServlet.class);
    private static final long serialVersionUID = 1L;
    private ApplicationContext applicationContext;
    private String realm;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml; charset=utf-8");
        PrintWriter out = response.getWriter();
        try {
            ConfigService cs = (ConfigService)this.getApplicationContext().getBean("config");
            Idp idpConfig = cs.getIDP(this.realm);
            LOG.debug(idpConfig.toString());
            MetadataWriter mw = new MetadataWriter();
            Document metadata = mw.getMetaData(idpConfig);
            out.write(DOM2Writer.nodeToString((Node)metadata));
        }
        catch (Exception ex) {
            LOG.error("Failed to get metadata document: ", (Throwable)ex);
            response.sendError(500);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.realm = config.getInitParameter(PARAM_REALM);
        if (this.realm == null || this.realm.length() == 0) {
            throw new ServletException("Servlet parameter 'realm' not defined");
        }
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            LOG.debug(this.getServletContext().toString());
            this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        }
        return this.applicationContext;
    }
}

