/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.AbstractSTSClient;
import org.apache.cxf.ws.security.trust.STSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpSTSClient
extends STSClient {
    private static final Logger LOG = LoggerFactory.getLogger(IdpSTSClient.class);

    public IdpSTSClient(Bus b) {
        super(b);
    }

    public String requestSecurityTokenResponse() throws Exception {
        return this.requestSecurityTokenResponse(null);
    }

    public String requestSecurityTokenResponse(String appliesTo) throws Exception {
        String action = null;
        if (this.isSecureConv) {
            action = this.namespace + "/RST/SCT";
        }
        return this.requestSecurityTokenResponse(appliesTo, action, "/Issue", null);
    }

    public String requestSecurityTokenResponse(String appliesTo, String action, String requestType, SecurityToken target) throws Exception {
        AbstractSTSClient.STSResponse response = this.issue(appliesTo, null, "/Issue", null);
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(response.getResponse(), new StreamResult(sw));
        }
        catch (TransformerException te) {
            LOG.warn("nodeToString Transformer Exception");
        }
        return sw.toString();
    }
}

