/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class FederationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationEntryPoint.class);
    private ApplicationContext appContext;
    private ConfigService configService;
    private String realm;
    private Idp idpConfig;

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.appContext, (String)"ApplicationContext cannot be null.");
        Assert.notNull((Object)this.configService, (String)"ConfigService cannot be null.");
        Assert.notNull((Object)this.realm, (String)"realm cannot be null.");
    }

    public final void commence(HttpServletRequest servletRequest, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        String loginUri;
        this.idpConfig = this.configService.getIDP(this.realm);
        Assert.notNull((Object)this.idpConfig, (String)"idpConfig cannot be null. Check realm and config service implementation");
        String redirectUrl = null;
        String wauth = servletRequest.getParameter("wauth");
        if (wauth == null) {
            wauth = "default";
        }
        if ((loginUri = (String)this.idpConfig.getAuthenticationURIs().get(wauth)) == null) {
            LOG.warn("wauth value '" + wauth + "' not supported");
            response.sendError(500, "wauth value '" + wauth + "' not supported");
        }
        redirectUrl = this.extractFullContextPath(servletRequest) + loginUri + "?" + servletRequest.getQueryString();
        this.preCommence(servletRequest, response);
        if (LOG.isInfoEnabled()) {
            LOG.info("Redirect to " + redirectUrl);
        }
        response.sendRedirect(redirectUrl);
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    protected String extractFullContextPath(HttpServletRequest request) throws MalformedURLException {
        String result = null;
        String contextPath = request.getContextPath();
        String requestUrl = request.getRequestURL().toString();
        String requestPath = new URL(requestUrl).getPath();
        if (requestPath != null && requestPath.length() > 0) {
            int lastIndex = requestUrl.lastIndexOf(requestPath);
            result = requestUrl.substring(0, lastIndex);
        } else {
            result = requestUrl;
        }
        if (contextPath != null && contextPath.length() > 0) {
            result = result + contextPath;
        }
        if (result.charAt(result.length() - 1) != '/') {
            result = result + "/";
        }
        return result;
    }
}

