/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WebUtils {
    private WebUtils() {
    }

    public static HttpServletRequest getHttpServletRequest(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletRequest)context.getExternalContext().getNativeRequest();
    }

    public static HttpSession getHttpSession(RequestContext context) {
        HttpServletRequest httpServletRequest = WebUtils.getHttpServletRequest((RequestContext)context);
        return httpServletRequest.getSession();
    }

    public static HttpServletResponse getHttpServletResponse(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletResponse)context.getExternalContext().getNativeResponse();
    }

    public static void putAttributeInRequestScope(RequestContext context, String attributeKey, Object attributeValue) {
        context.getRequestScope().put(attributeKey, attributeValue);
    }

    public static void putAttributeInExternalContext(RequestContext context, String attributeKey, Object attributeValue) {
        context.getExternalContext().getSessionMap().put(attributeKey, attributeValue);
    }

    public static void putAttribute(RequestContext context, String attributeKey, Object attributeValue, boolean storeInSession) {
        if (storeInSession) {
            WebUtils.putAttributeInExternalContext((RequestContext)context, (String)attributeKey, (Object)attributeValue);
        } else {
            WebUtils.putAttributeInRequestScope((RequestContext)context, (String)attributeKey, (Object)attributeValue);
        }
    }

    public static Object getAttributeFromRequestScope(RequestContext context, String attributeKey) {
        return context.getRequestScope().get(attributeKey);
    }

    public static Object getAttributeFromExternalContext(RequestContext context, String attributeKey) {
        return context.getExternalContext().getSessionMap().get(attributeKey);
    }

    public static Object getAttribute(RequestContext context, String attributeKey) {
        Object value = WebUtils.getAttributeFromRequestScope((RequestContext)context, (String)attributeKey);
        if (value != null) {
            return value;
        }
        return WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)attributeKey);
    }

    public static Object removeAttributeFromRequestScope(RequestContext context, String attributeKey) {
        return context.getRequestScope().remove(attributeKey);
    }

    public static Object removeAttributeFromExternalContext(RequestContext context, String attributeKey) {
        return context.getExternalContext().getSessionMap().remove(attributeKey);
    }

    public static Object removeAttribute(RequestContext context, String attributeKey) {
        Object valueReq = WebUtils.removeAttributeFromRequestScope((RequestContext)context, (String)attributeKey);
        Object valueSes = WebUtils.removeAttributeFromExternalContext((RequestContext)context, (String)attributeKey);
        if (valueSes != null) {
            return valueSes;
        }
        if (valueReq != null) {
            return valueReq;
        }
        return null;
    }

    public static void putAttributeInFlowScope(RequestContext context, String attributeKey, Object attributeValue) {
        context.getFlowScope().put(attributeKey, attributeValue);
    }

    public static Object getAttributeFromFlowScope(RequestContext context, String attributeKey) {
        return context.getFlowScope().get(attributeKey);
    }

    public static Object removeAttributeFromFlowScope(RequestContext context, String attributeKey) {
        return context.getFlowScope().remove(attributeKey);
    }

    public static String getParamFromRequestParameters(RequestContext context, String attributeKey) {
        return context.getRequestParameters().get(attributeKey);
    }

    public static Cookie readCookie(RequestContext context, String cookieName) {
        HttpServletRequest httpServletRequest = WebUtils.getHttpServletRequest((RequestContext)context);
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public static void addCookie(RequestContext context, String cookieName, String cookieValue) {
        HttpServletResponse httpServletResponse = WebUtils.getHttpServletResponse((RequestContext)context);
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setSecure(true);
        cookie.setMaxAge(-1);
        httpServletResponse.addCookie(cookie);
    }

    public static void removeCookie(RequestContext context, String cookieName) {
        HttpServletResponse httpServletResponse = WebUtils.getHttpServletResponse((RequestContext)context);
        Cookie cookie = WebUtils.readCookie((RequestContext)context, (String)cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
        }
    }
}

