/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.cxf.fediz.service.idp.model.IDPConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public Document getMetaData(IDPConfig config) throws RuntimeException {
        try {
            Crypto crypto = CertsUtils.createCrypto((String)config.getCertificate());
            ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(streamWriter);
            writer.writeStartDocument();
            String referenceID = "_" + UUIDGenerator.getUUID();
            writer.writeStartElement("", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("ID", referenceID);
            writer.writeAttribute("entityID", config.getIdpUrl());
            writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeStartElement("fed", "RoleDescriptor", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:SecurityTokenServiceType");
            writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
            if (config.getServiceDescription() != null && config.getServiceDescription().length() > 0) {
                writer.writeAttribute("ServiceDescription", config.getServiceDescription());
            }
            if (config.getServiceDisplayName() != null && config.getServiceDisplayName().length() > 0) {
                writer.writeAttribute("ServiceDisplayName", config.getServiceDisplayName());
            }
            writer.writeStartElement("", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("use", "signing");
            writer.writeStartElement("", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
            try {
                X509Certificate cert = CertsUtils.getX509Certificate((Crypto)crypto, null);
                writer.writeCharacters(Base64.encode((byte[])cert.getEncoded()));
            }
            catch (Exception ex) {
                LOG.error("Failed to add certificate information to metadata. Metadata incomplete", (Throwable)ex);
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("fed", "SecurityTokenServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            writer.writeCharacters(config.getStsUrl());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            writer.writeCharacters(config.getIdpUrl());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            if (config.getClaimTypesOffered() != null && config.getClaimTypesOffered().size() > 0) {
                writer.writeStartElement("fed", "ClaimTypesOffered", "http://docs.oasis-open.org/wsfed/federation/200706");
                for (String claim : config.getClaimTypesOffered()) {
                    writer.writeStartElement("auth", "ClaimType", "http://docs.oasis-open.org/wsfed/federation/200706");
                    writer.writeAttribute("Uri", claim);
                    writer.writeAttribute("Optional", "true");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            ((Writer)streamWriter).flush();
            bout.flush();
            if (LOG.isDebugEnabled()) {
                String out = new String(bout.toByteArray());
                LOG.debug("***************** unsigned ****************");
                LOG.debug(out);
                LOG.debug("***************** unsigned ****************");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bout.toByteArray());
            ByteArrayOutputStream result = SignatureUtils.signMetaInfo((Crypto)crypto, null, (String)config.getCertificatePassword(), (InputStream)is, (String)referenceID);
            if (result == null) {
                throw new RuntimeException("Failed to sign the metadata document: result=null");
            }
            is = new ByteArrayInputStream(result.toByteArray());
            return DOMUtils.readXml((InputStream)is);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating service metadata information ", (Throwable)e);
            throw new RuntimeException("Error creating service metadata information: " + e.getMessage());
        }
    }

    static {
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

