/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.io.IOException;
import org.apache.cxf.fediz.core.FederationProcessorImpl;
import org.apache.cxf.fediz.core.FederationRequest;
import org.apache.cxf.fediz.core.FederationResponse;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.config.jaxb.AudienceUris;
import org.apache.cxf.fediz.core.config.jaxb.CertificateStores;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.KeyStoreType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.TrustManagersType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuerType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuers;
import org.apache.cxf.fediz.core.config.jaxb.ValidationType;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.service.idp.model.IDPConfig;
import org.apache.cxf.fediz.service.idp.model.TrustedIDPConfig;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.util.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Element;

public class ValidateTokenAction {
    private static final String IDP_CONFIG = "idpConfig";
    private static final Logger LOG = LoggerFactory.getLogger(ValidateTokenAction.class);

    public SecurityToken submit(RequestContext context) throws ProcessingException, IOException {
        IDPConfig idpConfig = (IDPConfig)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)IDP_CONFIG);
        if (idpConfig == null) {
            throw new ProcessingException("IDP configuration is null", ProcessingException.TYPE.BAD_REQUEST);
        }
        String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
        if (whr == null) {
            throw new ProcessingException("Home realm is null", ProcessingException.TYPE.BAD_REQUEST);
        }
        String wresult = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wresult");
        if (wresult == null) {
            throw new ProcessingException("No security token issued", ProcessingException.TYPE.BAD_REQUEST);
        }
        TrustedIDPConfig trustedIDPConfig = (TrustedIDPConfig)idpConfig.getTrustedIDPs().get(whr);
        if (trustedIDPConfig == null) {
            throw new ProcessingException("No trusted IDP config found for home realm " + whr, ProcessingException.TYPE.BAD_REQUEST);
        }
        FederationContext fedContext = this.getFederationContext(idpConfig, trustedIDPConfig);
        FederationRequest wfReq = new FederationRequest();
        wfReq.setWa("wsignin1.0");
        wfReq.setWresult(wresult);
        FederationProcessorImpl wfProc = new FederationProcessorImpl();
        FederationResponse wfResp = wfProc.processRequest(wfReq, fedContext);
        fedContext.close();
        Element e = wfResp.getToken();
        String id = "_" + UUIDGenerator.getUUID();
        SecurityToken idpToken = new SecurityToken(id, wfResp.getTokenCreated(), wfResp.getTokenExpires());
        idpToken.setToken(e);
        LOG.info("[IDP_TOKEN=" + id + "] for user '" + wfResp.getUsername() + "' created from [RP_TOKEN=" + wfResp.getUniqueTokenId() + "] issued by home realm [" + whr + "/" + wfResp.getIssuer() + "].");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created date=" + wfResp.getTokenCreated());
            LOG.debug("Expired date=" + wfResp.getTokenExpires());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validated 'wresult' : " + System.getProperty("line.separator") + wresult);
        }
        return idpToken;
    }

    private FederationContext getFederationContext(IDPConfig idpConfig, TrustedIDPConfig trustedIdpConfig) throws ProcessingException {
        ContextConfig config = new ContextConfig();
        config.setName("whatever");
        CertificateStores certStores = new CertificateStores();
        TrustManagersType tm0 = new TrustManagersType();
        KeyStoreType ks0 = new KeyStoreType();
        ks0.setType("PEM");
        ks0.setFile(trustedIdpConfig.getCertificate());
        tm0.setKeyStore(ks0);
        certStores.getTrustManager().add(tm0);
        config.setCertificateStores(certStores);
        TrustedIssuers trustedIssuers = new TrustedIssuers();
        TrustedIssuerType ti0 = new TrustedIssuerType();
        ti0.setCertificateValidation(ValidationType.PEER_TRUST);
        ti0.setName(trustedIdpConfig.getName());
        trustedIssuers.getIssuer().add(ti0);
        config.setTrustedIssuers(trustedIssuers);
        FederationProtocolType protocol = new FederationProtocolType();
        config.setProtocol((ProtocolType)protocol);
        AudienceUris audienceUris = new AudienceUris();
        audienceUris.getAudienceItem().add(idpConfig.getRealm());
        config.setAudienceUris(audienceUris);
        FederationContext fedContext = new FederationContext(config);
        fedContext.init();
        return fedContext;
    }
}

