/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class SigninParametersCacheAction {
    private static final Logger LOG = LoggerFactory.getLogger(SigninParametersCacheAction.class);

    public void store(RequestContext context) {
        HashMap<String, Object> signinParams = new HashMap<String, Object>();
        String uuidKey = UUID.randomUUID().toString();
        Object value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreply");
        if (value != null) {
            signinParams.put("wreply", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wtrealm")) != null) {
            signinParams.put("wtrealm", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr")) != null) {
            signinParams.put("whr", value);
        }
        WebUtils.putAttributeInExternalContext((RequestContext)context, (String)uuidKey, signinParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignIn parameters cached: " + ((Object)signinParams).toString() + ".");
        }
        WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wctx", (Object)uuidKey);
        LOG.info("SignIn parameters cached and wctx set to [" + uuidKey + "].");
    }

    public void restore(RequestContext context) {
        String uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wctx");
        Map signinParams = (Map)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)uuidKey);
        String value = (String)signinParams.get("wreply");
        if (value != null) {
            WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wreply", (Object)value);
        }
        if ((value = (String)signinParams.get("wtrealm")) != null) {
            WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wtrealm", (Object)value);
        }
        if ((value = (String)signinParams.get("whr")) != null) {
            WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"whr", (Object)value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignIn parameters restored: " + signinParams.toString() + ".");
        }
        WebUtils.removeAttributeFromFlowScope((RequestContext)context, (String)"wctx");
        LOG.info("SignIn parameters restored and wctx[" + uuidKey + "] cleared.");
    }
}

