/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimTypes;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.fediz.service.idp.STSUserDetails;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.w3c.dom.Element;

public class STSAuthenticationProvider
implements AuthenticationProvider {
    private static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_BEARER = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
    private static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    private static final Logger LOG = LoggerFactory.getLogger(STSAuthenticationProvider.class);
    protected String wsdlLocation;
    protected String wsdlService;
    protected String wsdlEndpoint;
    protected String appliesTo;
    protected String tokenType;
    protected Bus bus;
    protected Integer lifetime;
    protected String roleURI;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Bus cxfBus = this.getBus();
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        if (this.tokenType != null && this.tokenType.length() > 0) {
            sts.setTokenType(this.tokenType);
        } else {
            sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        sts.setKeyType(HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_BEARER);
        sts.setWsdlLocation(this.wsdlLocation);
        sts.setServiceQName(new QName(HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512, this.wsdlService));
        sts.setEndpointQName(new QName(HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512, this.wsdlEndpoint));
        sts.getProperties().put("ws-security.username", authentication.getName());
        sts.getProperties().put("ws-security.password", (String)authentication.getCredentials());
        if (this.lifetime != null) {
            sts.setEnableLifetime(true);
            sts.setTtl(this.lifetime.intValue());
        }
        try {
            SecurityToken token = sts.requestSecurityToken(this.appliesTo);
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            if (this.roleURI != null) {
                AssertionWrapper assertion = new AssertionWrapper(token.getToken());
                List claims = this.parseClaimsInAssertion(assertion.getSaml2());
                for (Claim c : claims) {
                    if (!this.roleURI.equals(c.getClaimType())) continue;
                    Object oValue = c.getValue();
                    if (oValue instanceof List && !((List)oValue).isEmpty()) {
                        List values = (List)oValue;
                        for (String role : values) {
                            authorities.add(new SimpleGrantedAuthority(role));
                        }
                    } else {
                        LOG.error("Unsupported value type of Claim value");
                        throw new IllegalStateException("Unsupported value type of Claim value");
                    }
                    claims.remove(c);
                    break;
                }
            }
            UsernamePasswordAuthenticationToken upat = new UsernamePasswordAuthenticationToken((Object)authentication.getName(), authentication.getCredentials(), authorities);
            STSUserDetails details = new STSUserDetails(authentication.getName(), (String)authentication.getCredentials(), authorities, token);
            upat.setDetails((Object)details);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[IDP_TOKEN=" + token.getId() + "] provided for user '" + authentication.getName() + "'");
            }
            return upat;
        }
        catch (Exception ex) {
            LOG.info("Failed to authenticate user '" + authentication.getName() + "'", (Throwable)ex);
            return null;
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(String wsdlService) {
        this.wsdlService = wsdlService;
    }

    public String getWsdlEndpoint() {
        return this.wsdlEndpoint;
    }

    public void setWsdlEndpoint(String wsdlEndpoint) {
        this.wsdlEndpoint = wsdlEndpoint;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus != null ? this.bus : BusFactory.getDefaultBus();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap claimsMap = new HashMap();
        for (AttributeStatement statement : attributeStatements) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsing attribute: " + attribute.getName());
                }
                Claim c = new Claim();
                URI attrName = URI.create(attribute.getName());
                if (ClaimTypes.URI_BASE.toString().equals(attribute.getNameFormat()) && !attrName.isAbsolute()) {
                    c.setClaimType(URI.create(ClaimTypes.URI_BASE + "/" + attribute.getName()));
                } else {
                    c.setClaimType(URI.create(attribute.getName()));
                }
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" [" + value + "]");
                    }
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void mergeClaimToMap(Map<String, Claim> claimsMap, Claim c, List<String> valueList) {
        Claim t = claimsMap.get(c.getClaimType().toString());
        if (t != null) {
            Object oValue = t.getValue();
            if (oValue instanceof String) {
                ArrayList<String> values = new ArrayList<String>();
                values.add((String)oValue);
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            if (oValue instanceof List) {
                List values = (List)oValue;
                values.addAll(valueList);
                t.setValue((Object)values);
                return;
            }
            LOG.error("Unsupported value type of Claim value");
            throw new IllegalStateException("Unsupported value type of Claim value");
        }
        if (valueList.size() == 1) {
            c.setValue((Object)valueList.get(0));
        } else {
            c.setValue(valueList);
        }
        claimsMap.put(c.getClaimType().toString(), c);
    }

    public String getRoleURI() {
        return this.roleURI;
    }

    public void setRoleURI(String roleURI) {
        this.roleURI = roleURI;
    }
}

