/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutFilter
implements Filter {
    public static final String IDP_USER = "idp-user";
    public static final String LOGOUT_URI = "logout.uri";
    private static final Logger LOG = LoggerFactory.getLogger(LogoutFilter.class);
    private String logoutUri = "logout";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(LOGOUT_URI) != null) {
            this.logoutUri = filterConfig.getInitParameter(LOGOUT_URI);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hrequest;
        if (request instanceof HttpServletRequest && (hrequest = (HttpServletRequest)request).getParameter(this.logoutUri) != null) {
            HttpSession session = hrequest.getSession(false);
            if (session == null) {
                LOG.info("Logout ignored. No session available.");
                return;
            }
            LOG.info("Logout session for '" + session.getAttribute(IDP_USER) + "'");
            session.invalidate();
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

