/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Element;

public class IdpServlet
extends HttpServlet {
    public static final String PARAM_ACTION = "wa";
    public static final String ACTION_SIGNIN = "wsignin1.0";
    public static final String ACTION_SIGNOUT = "wsignout1.0";
    public static final String ACTION_SIGNOUT_CLEANUP = "wsignoutcleanup1.0";
    public static final String PARAM_WTREALM = "wtrealm";
    public static final String PARAM_WREPLY = "wreply";
    public static final String PARAM_WRESULT = "wresult";
    public static final String PARAM_WCONTEXT = "wctx";
    public static final String PARAM_WFRESH = "wfresh";
    public static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    public static final String SERVLET_PARAM_TOKENTYPE = "ws-trust-tokentype";
    public static final String IDP_TOKEN = "idp-token";
    public static final String IDP_USER = "idp-user";
    private static final Logger LOG = LoggerFactory.getLogger(IdpServlet.class);
    private static final String S_PARAM_TOKEN_INTERNAL_LIFETIME = "token.internal.lifetime";
    private static final String S_PARAM_STS_RP_URI = "sts.RP.uri";
    private static final String S_PARAM_STS_UT_URI = "sts.UT.uri";
    private static final String S_PARAM_STS_RP_WSDL_ENDPOINT = "sts.RP.wsdl.endpoint";
    private static final String S_PARAM_STS_UT_WSDL_ENDPOINT = "sts.UT.wsdl.endpoint";
    private static final String S_PARAM_STS_WSDL_SERVICE = "sts.wsdl.service";
    private static final String S_PARAM_STS_WSDL_URL = "sts.wsdl.url";
    private static final String S_PARAM_STS_USE_WFRESH_FOR_TTL = "sts.use.wfresh.for.ttl";
    private static final long serialVersionUID = -9019993850246851112L;
    protected boolean isPortSet;
    protected String stsWsdlUrl;
    protected boolean useWfreshForTTL;
    private String tokenType;
    private Bus bus;

    public void init() throws ServletException {
        this.stsWsdlUrl = this.getInitParameter(S_PARAM_STS_WSDL_URL);
        if (this.stsWsdlUrl == null) {
            throw new ServletException("Parameter 'sts.wsdl.url' not configured");
        }
        try {
            URL url = new URL(this.stsWsdlUrl);
            boolean bl = this.isPortSet = url.getPort() > 0;
            if (!this.isPortSet) {
                LOG.info("Port is 0 for 'sts.wsdl.url'. Port evaluated when processing first request.");
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Invalid Url '" + this.stsWsdlUrl + "': " + e.getMessage());
        }
        if (this.getInitParameter(S_PARAM_STS_WSDL_SERVICE) == null) {
            throw new ServletException("Parameter 'sts.wsdl.service' not configured");
        }
        if (this.getInitParameter(S_PARAM_STS_UT_WSDL_ENDPOINT) == null) {
            throw new ServletException("Parameter 'sts.UT.wsdl.endpoint' not configured");
        }
        if (this.getInitParameter(S_PARAM_STS_RP_WSDL_ENDPOINT) == null) {
            throw new ServletException("Parameter 'sts.RP.wsdl.endpoint' not configured");
        }
        if (this.getInitParameter(S_PARAM_STS_UT_URI) == null) {
            throw new ServletException("Parameter 'sts.UT.uri' not configured");
        }
        if (this.getInitParameter(S_PARAM_STS_RP_URI) == null) {
            throw new ServletException("Parameter 'sts.RP.uri' not configured");
        }
        this.tokenType = this.getInitParameter(SERVLET_PARAM_TOKENTYPE);
        if (this.tokenType != null && this.tokenType.length() > 0) {
            LOG.info("Configured Tokentype: " + this.tokenType);
        }
        if (this.getInitParameter(S_PARAM_TOKEN_INTERNAL_LIFETIME) != null) {
            LOG.info("Configured token lifetime: " + this.getInitParameter(S_PARAM_TOKEN_INTERNAL_LIFETIME));
        }
        try {
            String wfreshParam = this.getInitParameter(S_PARAM_STS_USE_WFRESH_FOR_TTL);
            this.useWfreshForTTL = wfreshParam != null ? Boolean.valueOf(wfreshParam) : true;
        }
        catch (Exception ex) {
            LOG.error("Failed to parse parameter 'sts.use.wfresh.for.ttl': " + ex.toString());
            throw new ServletException("Failed to parse parameter 'sts.use.wfresh.for.ttl'");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isPortSet) {
            try {
                URL url = new URL(this.stsWsdlUrl);
                URL updatedUrl = new URL(url.getProtocol(), url.getHost(), request.getLocalPort(), url.getFile());
                this.setSTSWsdlUrl(updatedUrl.toString());
                LOG.info("STS WSDL URL updated to " + updatedUrl.toString());
            }
            catch (MalformedURLException e) {
                LOG.error("Invalid Url '" + this.stsWsdlUrl + "': " + e.getMessage());
            }
        }
        String action = request.getParameter(PARAM_ACTION);
        String wtrealm = request.getParameter(PARAM_WTREALM);
        String wctx = request.getParameter(PARAM_WCONTEXT);
        String wreply = request.getParameter(PARAM_WREPLY);
        String wfresh = request.getParameter(PARAM_WFRESH);
        if (action == null) {
            LOG.error("Bad request. HTTP parameter 'wa' missing");
            response.sendError(400, "Parameter wa missing");
            return;
        }
        if (action.equals(ACTION_SIGNIN)) {
            LOG.debug("Sign-In request [wa=wsignin1.0] ...");
            if (wtrealm == null || wtrealm.length() == 0) {
                LOG.error("Bad request. HTTP parameter 'wsignin1.0' missing");
                response.sendError(400, "Parameter wsignin1.0 missing");
                return;
            }
            boolean authenticationRequired = false;
            SecurityToken idpToken = null;
            HttpSession session = request.getSession(false);
            if (session != null) {
                idpToken = (SecurityToken)session.getAttribute(IDP_TOKEN);
                String user = (String)session.getAttribute(IDP_USER);
                if (idpToken == null) {
                    LOG.error("IDP token not found");
                    response.sendError(500, "IDP token not found");
                    return;
                }
                if (idpToken.isExpired()) {
                    LOG.info("IDP token of '" + user + "' expired. Require authentication.");
                    authenticationRequired = idpToken.isExpired();
                } else if (wfresh != null) {
                    authenticationRequired = this.parseWfresh(wfresh, user, idpToken);
                }
                if (!authenticationRequired) {
                    LOG.debug("Session found for '" + user + "'.");
                }
            } else {
                authenticationRequired = true;
            }
            if (authenticationRequired) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication required ...");
                }
                String auth = request.getHeader("Authorization");
                LOG.debug("Authorization header: " + auth);
                if (auth == null) {
                    StringBuilder value = new StringBuilder(16);
                    value.append("Basic realm=\"IDP\"");
                    response.setHeader(AUTH_HEADER_NAME, value.toString());
                    response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
                    response.sendError(401);
                    return;
                }
                String username = null;
                String password = null;
                try {
                    StringTokenizer st = new StringTokenizer(auth, " ");
                    String authType = st.nextToken();
                    String encoded = st.nextToken();
                    if (!authType.equalsIgnoreCase("basic")) {
                        response.sendError(400, "Invalid Authorization header");
                        return;
                    }
                    String decoded = new String(Base64Utility.decode((String)encoded));
                    int colon = decoded.indexOf(58);
                    if (colon < 0) {
                        username = decoded;
                    } else {
                        username = decoded.substring(0, colon);
                        password = decoded.substring(colon + 1, decoded.length());
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Validating user '" + username + "'...");
                    }
                    try {
                        idpToken = this.requestSecurityTokenForIDP(username, password, "urn:fediz:idp", wfresh);
                        session = request.getSession(true);
                        session.setAttribute(IDP_TOKEN, (Object)idpToken);
                        session.setAttribute(IDP_USER, (Object)username);
                    }
                    catch (Exception ex) {
                        LOG.info("Requesting IDP security token failed", (Throwable)ex);
                        response.sendError(403, "Requesting IDP security token failed");
                        return;
                    }
                }
                catch (Exception ex) {
                    LOG.error("Invalid Authorization header", (Throwable)ex);
                    response.sendError(400, "Invalid Authorization header");
                    return;
                }
            }
            String wresult = null;
            String user = (String)session.getAttribute(IDP_USER);
            if (LOG.isInfoEnabled()) {
                LOG.info("Requesting token on-behalf-of '" + user + "' for relying party '" + wtrealm);
            }
            try {
                wresult = this.requestSecurityTokenForRP(idpToken, wtrealm);
                request.setAttribute("fed.wresult", (Object)StringEscapeUtils.escapeXml((String)wresult));
                if (wctx != null) {
                    request.setAttribute("fed.wctx", (Object)StringEscapeUtils.escapeXml((String)wctx));
                }
                if (wreply == null) {
                    request.setAttribute("fed.action", (Object)wtrealm);
                }
                request.setAttribute("fed.action", (Object)wreply);
            }
            catch (Exception ex) {
                LOG.info("Requesting security token failed", (Throwable)ex);
                response.sendError(403, "Requesting security token failed");
                return;
            }
        } else {
            response.sendError(400, "Parameter wa with value " + action + " is not supported");
            return;
        }
        LOG.debug("Forward to jsp...");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
        this.getServletContext().getRequestDispatcher("/WEB-INF/signinresponse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private SecurityToken requestSecurityTokenForIDP(String username, String password, String appliesTo, String wfresh) throws Exception {
        Bus cxfBus = this.getBus();
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
        if (this.tokenType != null && this.tokenType.length() > 0) {
            sts.setTokenType(this.tokenType);
        } else {
            sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.stsWsdlUrl + this.getInitParameter(S_PARAM_STS_UT_URI) + "?wsdl");
        sts.setServiceQName(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", this.getInitParameter(S_PARAM_STS_WSDL_SERVICE)));
        sts.setEndpointQName(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", this.getInitParameter(S_PARAM_STS_UT_WSDL_ENDPOINT)));
        sts.getProperties().put("ws-security.username", username);
        sts.getProperties().put("ws-security.password", password);
        this.configureTTL(sts, wfresh);
        return sts.requestSecurityToken(appliesTo);
    }

    private void configureTTL(IdpSTSClient sts, String wfresh) {
        int ttl;
        if (wfresh != null) {
            try {
                ttl = Integer.parseInt(wfresh);
                if (ttl > 0) {
                    sts.setTtl(ttl * 60);
                    sts.setEnableLifetime(true);
                    return;
                }
            }
            catch (NumberFormatException ex) {
                LOG.error("Invalid wfresh value '" + wfresh + "': " + ex.getMessage());
            }
        }
        if (this.getInitParameter(S_PARAM_TOKEN_INTERNAL_LIFETIME) != null) {
            sts.setEnableLifetime(true);
            ttl = Integer.parseInt(this.getInitParameter(S_PARAM_TOKEN_INTERNAL_LIFETIME));
            sts.setTtl(ttl);
        }
    }

    private String requestSecurityTokenForRP(SecurityToken onbehalfof, String appliesTo) throws Exception {
        try {
            Bus cxfBus = this.getBus();
            List realmClaims = null;
            ApplicationContext ctx = (ApplicationContext)cxfBus.getExtension(ApplicationContext.class);
            try {
                Map realmClaimsMap = (Map)ctx.getBean("realm2ClaimsMap");
                realmClaims = (List)realmClaimsMap.get(appliesTo);
                if (realmClaims != null && realmClaims.size() > 0 && LOG.isDebugEnabled()) {
                    LOG.debug("claims for realm " + appliesTo);
                    for (String item : realmClaims) {
                        LOG.debug("  " + item);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Failed to read bean 'realm2ClaimsMap'", (Throwable)ex);
            }
            IdpSTSClient sts = new IdpSTSClient(cxfBus);
            sts.setAddressingNamespace("http://www.w3.org/2005/08/addressing");
            if (this.tokenType != null && this.tokenType.length() > 0) {
                sts.setTokenType(this.tokenType);
            } else {
                sts.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
            sts.setWsdlLocation(this.stsWsdlUrl + this.getInitParameter(S_PARAM_STS_RP_URI) + "?wsdl");
            sts.setServiceQName(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", this.getInitParameter(S_PARAM_STS_WSDL_SERVICE)));
            sts.setEndpointQName(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", this.getInitParameter(S_PARAM_STS_RP_WSDL_ENDPOINT)));
            sts.setOnBehalfOf((Object)onbehalfof.getToken());
            Element claims = this.createClaimsElement(realmClaims);
            if (claims != null) {
                sts.setClaims(claims);
            }
            return sts.requestSecurityTokenResponse(appliesTo);
        }
        catch (SoapFault ex) {
            QName faultCode = ex.getFaultCode();
            if (faultCode.equals(STSException.FAILED_AUTH)) {
                LOG.warn("Failed authentication for '" + onbehalfof.getPrincipal().getName() + "'");
            }
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private Element createClaimsElement(List<String> realmClaims) throws Exception {
        if (realmClaims == null || realmClaims.size() == 0) {
            return null;
        }
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "Claims", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("ic", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        writer.writeAttribute("Dialect", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (realmClaims != null && realmClaims.size() > 0) {
            for (String item : realmClaims) {
                LOG.debug("claim: " + item);
                writer.writeStartElement("ic", "ClaimType", "http://schemas.xmlsoap.org/ws/2005/05/identity");
                writer.writeAttribute("Uri", item);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        return writer.getDocument().getDocumentElement();
    }

    private boolean parseWfresh(String wfresh, String user, SecurityToken idpToken) {
        if ("0".equals(wfresh)) {
            LOG.info("IDP token of '" + user + "' valid but relying party requested new authentication");
            return true;
        }
        long ttl = Long.parseLong(wfresh);
        if (ttl > 0L) {
            Date createdDate = idpToken.getCreated();
            Date expiryDate = new Date();
            expiryDate.setTime(createdDate.getTime() + ttl * 60L * 1000L);
            if (expiryDate.before(new Date())) {
                LOG.info("IDP token of '" + user + "' valid but relying party requested new authentication via wfresh: " + wfresh);
                return true;
            }
        } else {
            LOG.info("wfresh value of " + wfresh + " is invalid");
        }
        return false;
    }

    private synchronized void setSTSWsdlUrl(String wsdlUrl) {
        this.stsWsdlUrl = wsdlUrl;
        this.isPortSet = true;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus != null ? this.bus : BusFactory.getDefaultBus();
    }
}

