/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.plugin.state;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.cxf.plugin.state.ResponseState;
import org.apache.cxf.fediz.cxf.plugin.state.SPStateManager;
import org.apache.wss4j.common.cache.EHCacheManagerHolder;
import org.apache.wss4j.common.util.Loader;

public class EHCacheSPStateManager
implements SPStateManager {
    public static final long DEFAULT_TTL = 300L;
    public static final String REQUEST_CACHE_KEY = "cxf.fediz.samlp.request.state.cache";
    public static final String RESPONSE_CACHE_KEY = "cxf.fediz.samlp.response.state.cache";
    private Ehcache requestCache;
    private Ehcache responseCache;
    private CacheManager cacheManager;
    private long ttl = 300L;

    public EHCacheSPStateManager(String configFile) {
        this(EHCacheSPStateManager.getConfigFileURL(configFile));
    }

    public EHCacheSPStateManager(URL configFileURL) {
        this(EHCacheManagerHolder.getCacheManager((String)"", (URL)configFileURL));
    }

    public EHCacheSPStateManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        CacheConfiguration requestCC = EHCacheManagerHolder.getCacheConfiguration((String)REQUEST_CACHE_KEY, (CacheManager)cacheManager);
        Cache newCache = new Cache(requestCC);
        this.requestCache = cacheManager.addCacheIfAbsent((Ehcache)newCache);
        CacheConfiguration responseCC = EHCacheManagerHolder.getCacheConfiguration((String)RESPONSE_CACHE_KEY, (CacheManager)cacheManager);
        newCache = new Cache(responseCC);
        this.responseCache = cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    private static URL getConfigFileURL(Object o) {
        if (o instanceof String) {
            try {
                URL url = Loader.getResource((String)((String)o));
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException iOException) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        if (relayState == null || "".equals(relayState)) {
            return;
        }
        int parsedTTL = (int)this.ttl;
        if (this.ttl != (long)parsedTTL) {
            parsedTTL = 3600;
        }
        Element element = new Element((Serializable)((Object)relayState), (Serializable)state);
        element.setTimeToLive(parsedTTL);
        element.setTimeToIdle(parsedTTL);
        this.requestCache.put(element);
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        Element element = this.requestCache.get((Serializable)((Object)relayState));
        if (element != null) {
            this.requestCache.remove((Serializable)((Object)relayState));
            return (RequestState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        Element element = this.responseCache.get((Serializable)((Object)securityContextKey));
        if (element != null) {
            if (this.responseCache.isExpired(element)) {
                this.responseCache.remove((Serializable)((Object)securityContextKey));
                return null;
            }
            return (ResponseState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        Element element = this.responseCache.get((Serializable)((Object)securityContextKey));
        if (element != null) {
            this.responseCache.remove((Serializable)((Object)securityContextKey));
            return (ResponseState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        if (securityContextKey == null || "".equals(securityContextKey)) {
            return;
        }
        int parsedTTL = (int)this.ttl;
        if (this.ttl != (long)parsedTTL) {
            parsedTTL = 300;
        }
        Element element = new Element((Serializable)((Object)securityContextKey), (Serializable)state);
        element.setTimeToLive(parsedTTL);
        element.setTimeToIdle(parsedTTL);
        this.responseCache.put(element);
    }

    @Override
    public void close() throws IOException {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
            this.cacheManager = null;
            this.requestCache = null;
            this.responseCache = null;
        }
    }
}

