/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.core.util.CookieUtils;
import org.apache.cxf.fediz.cxf.plugin.AbstractServiceProviderFilter;
import org.apache.cxf.fediz.cxf.plugin.state.ResponseState;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.wss4j.common.util.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FedizRedirectBindingFilter
extends AbstractServiceProviderFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FedizRedirectBindingFilter.class);
    @Context
    private MessageContext messageContext;
    private boolean redirectOnInitialSignIn;

    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        FedizContext fedConfig = this.getFedizContext(m);
        if (this.isMetadataRequest(context, fedConfig)) {
            return;
        }
        String httpMethod = context.getMethod();
        MultivaluedMap params = null;
        try {
            if ("GET".equals(httpMethod)) {
                params = context.getUriInfo().getQueryParameters();
            } else if ("POST".equals(httpMethod)) {
                String strForm = IOUtils.toString((InputStream)context.getEntityStream());
                params = JAXRSUtils.getStructuredParams((String)strForm, (String)"&", (boolean)true, (boolean)false);
            }
        }
        catch (Exception ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
        if (this.isLogoutRequest(context, fedConfig, m, (MultivaluedMap<String, String>)params) || this.isSignoutCleanupRequest(fedConfig, m, (MultivaluedMap<String, String>)params)) {
            return;
        }
        if (this.checkSecurityContext(fedConfig, m, (MultivaluedMap<String, String>)params)) {
            return;
        }
        if (this.isSignInRequired(fedConfig, (MultivaluedMap<String, String>)params)) {
            this.processSignInRequired(context, fedConfig);
        } else if (this.isSignInRequest(fedConfig, (MultivaluedMap<String, String>)params)) {
            this.processSignInRequest(context, fedConfig, m, (MultivaluedMap<String, String>)params);
        } else {
            LOG.error("SignIn parameter is incorrect or not supported");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }

    private void processSignInRequest(ContainerRequestContext context, FedizContext fedConfig, Message m, MultivaluedMap<String, String> params) {
        String responseToken = this.getResponseToken(fedConfig, params);
        String state = this.getState(fedConfig, params);
        if (responseToken == null) {
            LOG.debug("SignIn request must contain a response token from the IdP");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        LOG.debug("Process SignIn request");
        LOG.debug("token=\n{}", (Object)responseToken);
        FedizResponse wfRes = this.validateSignInRequest(fedConfig, params, responseToken, state);
        List audienceURIs = fedConfig.getAudienceUris();
        HttpServletRequest request = this.messageContext.getHttpServletRequest();
        this.validateAudienceRestrictions(wfRes, audienceURIs, request);
        String securityContextKey = UUID.randomUUID().toString();
        long currentTime = System.currentTimeMillis();
        Date notOnOrAfter = wfRes.getTokenExpires();
        long expiresAt = 0L;
        expiresAt = notOnOrAfter != null ? notOnOrAfter.getTime() : currentTime + this.getStateTimeToLive();
        String webAppDomain = this.getWebAppDomain();
        String token = DOM2Writer.nodeToString((Node)wfRes.getToken());
        List<String> roles = wfRes.getRoles();
        if (roles == null || roles.isEmpty()) {
            roles = Collections.singletonList("Authenticated");
        } else if (fedConfig.isAddAuthenticatedRole()) {
            roles = new ArrayList<String>(roles);
            roles.add("Authenticated");
        }
        String webAppContext = this.getWebAppContext(m);
        ResponseState responseState = new ResponseState(token, state, webAppContext, webAppDomain, currentTime, expiresAt);
        responseState.setClaims(wfRes.getClaims());
        responseState.setRoles(roles);
        responseState.setIssuer(wfRes.getIssuer());
        responseState.setSubject(wfRes.getUsername());
        this.getStateManager().setResponseState(securityContextKey, responseState);
        long stateTimeToLive = this.getStateTimeToLive();
        String contextCookie = CookieUtils.createCookie((String)"org.apache.fediz.SECURITY_TOKEN", (String)securityContextKey, (String)webAppContext, (String)webAppDomain, (long)stateTimeToLive);
        if (this.isRedirectOnInitialSignIn()) {
            Response.ResponseBuilder response = Response.seeOther((URI)new UriInfoImpl(m).getAbsolutePath());
            response.header("Set-Cookie", (Object)contextCookie);
            context.abortWith(response.build());
        } else {
            try {
                this.setSecurityContext(responseState, m, wfRes.getToken());
                context.setProperty("org.apache.fediz.SECURITY_TOKEN", (Object)contextCookie);
            }
            catch (Exception ex) {
                this.reportError("INVALID_RESPONSE_STATE");
            }
        }
    }

    private void processSignInRequired(ContainerRequestContext context, FedizContext fedConfig) {
        FedizProcessor processor = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
        HttpServletRequest request = this.messageContext.getHttpServletRequest();
        try {
            Response.ResponseBuilder response;
            RedirectionResponse redirectionResponse = processor.createSignInRequest(request, fedConfig);
            String redirectURL = redirectionResponse.getRedirectionURL();
            if (redirectURL != null) {
                RequestState requestState;
                response = Response.seeOther((URI)new URI(redirectURL));
                Map headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (Map.Entry entry : headers.entrySet()) {
                        response.header((String)entry.getKey(), entry.getValue());
                    }
                }
                if ((requestState = redirectionResponse.getRequestState()) != null && requestState.getState() != null) {
                    this.getStateManager().setRequestState(requestState.getState(), requestState);
                    String contextCookie = CookieUtils.createCookie((String)"org.apache.fediz.SECURITY_CONTEXT_STATE", (String)requestState.getState(), (String)request.getRequestURI(), (String)this.getWebAppDomain(), (long)this.getStateTimeToLive());
                    response.header("Set-Cookie", (Object)contextCookie);
                }
            } else {
                LOG.warn("Failed to create SignInRequest.");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            context.abortWith(response.build());
        }
        catch (Exception ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    private boolean isMetadataRequest(ContainerRequestContext context, FedizContext fedConfig) {
        String requestPath = context.getUriInfo().getPath();
        if (requestPath.indexOf("FederationMetadata/2007-06/FederationMetadata.xml") != -1 || requestPath.indexOf(this.getMetadataURI(fedConfig)) != -1) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Metadata document requested");
            }
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
            try {
                HttpServletRequest request = this.messageContext.getHttpServletRequest();
                Document metadata = wfProc.getMetaData(request, fedConfig);
                String metadataStr = DOM2Writer.nodeToString((Node)metadata);
                Response.ResponseBuilder response = Response.ok((Object)metadataStr, (String)"text/xml");
                context.abortWith(response.build());
                return true;
            }
            catch (Exception ex) {
                LOG.error("Failed to get metadata document: " + ex.getMessage());
                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
            }
        }
        return false;
    }

    private boolean isLogoutRequest(ContainerRequestContext context, FedizContext fedConfig, Message message, MultivaluedMap<String, String> params) {
        String requestPath;
        boolean signout = false;
        String logoutUrl = fedConfig.getLogoutURL();
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol && "wsignout1.0".equals(params.getFirst((Object)"wa"))) {
            signout = true;
        } else if (logoutUrl != null && !logoutUrl.isEmpty() && ((requestPath = "/" + context.getUriInfo().getPath()).equals(logoutUrl) || requestPath.equals(logoutUrl + "/"))) {
            signout = true;
        }
        if (signout) {
            this.cleanupContext(message);
            try {
                FedizProcessor processor = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
                HttpServletRequest request = this.messageContext.getHttpServletRequest();
                RedirectionResponse redirectionResponse = processor.createSignOutRequest(request, null, fedConfig);
                String redirectURL = redirectionResponse.getRedirectionURL();
                if (redirectURL != null) {
                    Response.ResponseBuilder response = Response.seeOther((URI)new URI(redirectURL));
                    Map headers = redirectionResponse.getHeaders();
                    if (!headers.isEmpty()) {
                        for (Map.Entry entry : headers.entrySet()) {
                            response.header((String)entry.getKey(), entry.getValue());
                        }
                    }
                    context.abortWith(response.build());
                    return true;
                }
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
            }
        }
        return false;
    }

    private void cleanupContext(Message message) {
        String contextKey;
        HttpHeadersImpl headers = new HttpHeadersImpl(message);
        Map cookies = headers.getCookies();
        if (cookies.containsKey("org.apache.fediz.SECURITY_TOKEN")) {
            contextKey = ((Cookie)cookies.get("org.apache.fediz.SECURITY_TOKEN")).getValue();
            this.getStateManager().removeResponseState(contextKey);
        }
        if (cookies.containsKey("org.apache.fediz.SECURITY_CONTEXT_STATE")) {
            contextKey = ((Cookie)cookies.get("org.apache.fediz.SECURITY_CONTEXT_STATE")).getValue();
            this.getStateManager().removeRequestState(contextKey);
        }
    }

    private String getMetadataURI(FedizContext fedConfig) {
        if (fedConfig.getProtocol().getMetadataURI() != null) {
            return fedConfig.getProtocol().getMetadataURI();
        }
        if (fedConfig.getProtocol() instanceof FederationProtocol) {
            return "FederationMetadata/2007-06/FederationMetadata.xml";
        }
        if (fedConfig.getProtocol() instanceof SAMLProtocol) {
            return "SAML/Metadata.xml";
        }
        return "FederationMetadata/2007-06/FederationMetadata.xml";
    }

    private boolean isSignInRequired(FedizContext fedConfig, MultivaluedMap<String, String> params) {
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol && params.getFirst((Object)"wa") == null) {
            return true;
        }
        return params != null && fedConfig.getProtocol() instanceof SAMLProtocol && params.getFirst((Object)"RelayState") == null;
    }

    private boolean isSignInRequest(FedizContext fedConfig, MultivaluedMap<String, String> params) {
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol && "wsignin1.0".equals(params.getFirst((Object)"wa"))) {
            return true;
        }
        return params != null && fedConfig.getProtocol() instanceof SAMLProtocol && params.getFirst((Object)"RelayState") != null;
    }

    private boolean isSignoutCleanupRequest(FedizContext fedConfig, Message m, MultivaluedMap<String, String> params) {
        boolean signoutCleanup = false;
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol && "wsignoutcleanup1.0".equals(params.getFirst((Object)"wa"))) {
            signoutCleanup = true;
        }
        if (signoutCleanup) {
            LOG.debug("SignOutCleanup request found");
            LOG.debug("SignOutCleanup action...");
            this.cleanupContext(m);
            HttpServletResponse response = this.messageContext.getHttpServletResponse();
            try {
                ServletOutputStream responseOutputStream = response.getOutputStream();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("logout.jpg");
                if (inputStream == null) {
                    LOG.warn("Could not write logout.jpg");
                    return true;
                }
                int read = 0;
                byte[] buf = new byte[1024];
                while ((read = inputStream.read(buf)) != -1) {
                    responseOutputStream.write(buf, 0, read);
                }
                inputStream.close();
                responseOutputStream.flush();
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
            }
            return true;
        }
        return false;
    }

    private String getResponseToken(FedizContext fedConfig, MultivaluedMap<String, String> params) {
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol) {
            return (String)params.getFirst((Object)"wresult");
        }
        if (params != null && fedConfig.getProtocol() instanceof SAMLProtocol) {
            return (String)params.getFirst((Object)"SAMLResponse");
        }
        return null;
    }

    private FedizResponse validateSignInRequest(FedizContext fedConfig, MultivaluedMap<String, String> params, String responseToken, String state) {
        FedizRequest wfReq = new FedizRequest();
        wfReq.setAction((String)params.getFirst((Object)"wa"));
        wfReq.setResponseToken(responseToken);
        if (state == null || state.getBytes().length <= 0) {
            LOG.error("Invalid RelayState/WCTX");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        wfReq.setState(state);
        wfReq.setRequestState(this.getStateManager().removeRequestState(state));
        if (wfReq.getRequestState() == null) {
            LOG.error("Missing Request State");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (CookieUtils.isStateExpired((long)wfReq.getRequestState().getCreatedAt(), (boolean)false, (long)0L, (long)this.getStateTimeToLive())) {
            LOG.error("EXPIRED_REQUEST_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        HttpServletRequest request = this.messageContext.getHttpServletRequest();
        wfReq.setRequest(request);
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        wfReq.setCerts(certs);
        FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
        try {
            return wfProc.processRequest(wfReq, fedConfig);
        }
        catch (ProcessingException ex) {
            LOG.error("Federation processing failed: " + ex.getMessage());
            throw ExceptionUtils.toNotAuthorizedException((Throwable)ex, null);
        }
    }

    private void validateAudienceRestrictions(FedizResponse wfRes, List<String> audienceURIs, HttpServletRequest request) {
        if (wfRes.getAudience() != null) {
            boolean validAudience = false;
            for (String a : audienceURIs) {
                if (!wfRes.getAudience().startsWith(a)) continue;
                validAudience = true;
                break;
            }
            if (!validAudience) {
                LOG.warn("Token AudienceRestriction [" + wfRes.getAudience() + "] doesn't match with specified list of URIs.");
                throw ExceptionUtils.toForbiddenException(null, null);
            }
            if (LOG.isDebugEnabled() && request.getRequestURL().indexOf(wfRes.getAudience()) == -1) {
                LOG.debug("Token AudienceRestriction doesn't match with request URL [" + wfRes.getAudience() + "]  [" + request.getRequestURL() + "]");
            }
        }
    }

    public boolean isRedirectOnInitialSignIn() {
        return this.redirectOnInitialSignIn;
    }

    public void setRedirectOnInitialSignIn(boolean redirectOnInitialSignIn) {
        this.redirectOnInitialSignIn = redirectOnInitialSignIn;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String tokenContext = (String)requestContext.getProperty("org.apache.fediz.SECURITY_TOKEN");
        if (tokenContext != null) {
            responseContext.getHeaders().add((Object)"Set-Cookie", (Object)tokenContext);
        }
    }
}

