/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.example;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.SecurityTokenThreadLocal;
import org.w3c.dom.Element;

public class FederationServlet
extends HttpServlet {
    private static final long serialVersionUID = -9019993850246851112L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>WS Federation Example</title></head>");
        out.println("<body>");
        out.println("<h1>Hello World</h1>");
        out.println("Hello world<br>");
        out.println("Request url: ");
        out.println(request.getRequestURL());
        out.println("<p>");
        out.println("<br><b>User</b><p>");
        Principal p = request.getUserPrincipal();
        if (p != null) {
            out.println("Principal: " + p.getName() + "<p>");
        }
        out.println("<br><b>Roles</b><p>");
        List<String> roleListToCheck = Arrays.asList("Admin", "Manager", "User", "Authenticated");
        for (String item : roleListToCheck) {
            out.println("Has role '" + item + "': " + (request.isUserInRole(item) ? "<b>yes</b>" : "no") + "<p>");
        }
        if (p instanceof FedizPrincipal) {
            FedizPrincipal fp = (FedizPrincipal)p;
            out.println("<br><b>Claims</b><p>");
            ClaimCollection claims = fp.getClaims();
            for (Claim c : claims) {
                out.println(c.getClaimType().toString() + ": " + c.getValue() + "<p>");
            }
        } else {
            out.println("Principal is not instance of FedizPrincipal");
        }
        Element el = SecurityTokenThreadLocal.getToken();
        if (el != null) {
            out.println("<p>Bootstrap token...<p>");
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter token = new StringWriter();
                transformer.transform(new DOMSource(el), new StreamResult(token));
                out.println(StringEscapeUtils.escapeXml11((String)token.toString()));
            }
            catch (Exception ex) {
                out.println("Failed to transform cached element to string: " + ex.toString());
            }
        } else {
            out.println("<p>Bootstrap token not cached in thread local storage");
        }
        out.println("</body>");
    }
}

