/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.example;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.example.SecurityTokenThreadLocal;
import org.w3c.dom.Element;

public class FederationFilter
implements Filter {
    private static final String DEFAULT_SECURITY_TOKEN_ATTR = "org.apache.fediz.SECURITY_TOKEN";
    private static final String SECURITY_TOKEN_ATTR_CONFIG = "security.token.attribute";
    private String securityTokenAttr = "org.apache.fediz.SECURITY_TOKEN";

    public void init(FilterConfig filterConfig) throws ServletException {
        String attrName = filterConfig.getInitParameter(SECURITY_TOKEN_ATTR_CONFIG);
        if (attrName != null) {
            this.securityTokenAttr = attrName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            Element el = (Element)hrequest.getSession().getAttribute(this.securityTokenAttr);
            if (el != null) {
                try {
                    SecurityTokenThreadLocal.setToken((Element)el);
                    chain.doFilter(request, response);
                }
                finally {
                    SecurityTokenThreadLocal.setToken(null);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

