/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.systests.common.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.cxf.dosgi.samples.greeter.rest.GreeterException;
import org.apache.cxf.dosgi.samples.greeter.rest.GreeterInfo;
import org.apache.cxf.dosgi.samples.greeter.rest.GreeterService;
import org.apache.cxf.dosgi.samples.greeter.rest.GreetingPhrase;
import org.apache.cxf.dosgi.systests.common.rest.AbstractDosgiSystemTest;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerHookServiceListenerTest
extends AbstractDosgiSystemTest {
    private static final String ADDRESS1 = "http://localhost:9090/greeter";
    private static final String ADDRESS2 = "http://localhost:9089/greeter";
    private FutureTask<GreeterInfo> task1;
    private Object mutex1 = new Object();
    private FutureTask<GreeterInfo> task2;
    private Object mutex2 = new Object();

    protected String[] getTestBundlesNames() {
        return new String[]{this.getBundle("org.apache.cxf.dosgi.systests", "cxf-dosgi-ri-systests-common-rest"), this.getBundle("org.apache.cxf.dosgi.samples", "cxf-dosgi-ri-samples-greeter-rest-interface"), this.getBundle("org.apache.servicemix.specs", "org.apache.servicemix.specs.jsr311-api-1.0")};
    }

    @Override
    protected Resource[] getTestBundles() {
        ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(super.getTestBundles()));
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            String fn = ((Resource)it.next()).getFilename();
            if (!fn.startsWith("cxf-dosgi-ri-dsw-cxf") || !fn.endsWith(".jar")) continue;
            it.remove();
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInvocation() throws Exception {
        Thread.currentThread().setContextClassLoader(JAXRSClientFactoryBean.class.getClassLoader());
        this.bundleContext.registerService(new String[]{"javax.ws.rs.ext.MessageBodyReader"}, (Object)new AegisElementProvider(), new Hashtable());
        Server server1 = null;
        Server server2 = null;
        ServiceTracker tracker = null;
        try {
            server1 = this.startServer(ADDRESS1, GreeterService.class, new GreeterServiceImpl());
            server2 = this.startServer(ADDRESS2, GreeterService.class, new GreeterServiceImpl());
            tracker = new ServiceTracker(this.bundleContext, GreeterService.class.getName(), null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object addingService(final ServiceReference reference) {
                    Object result = super.addingService(reference);
                    FutureTask<GreeterInfo> future = new FutureTask<GreeterInfo>(new Callable<GreeterInfo>(){

                        @Override
                        public GreeterInfo call() {
                            return AbstractListenerHookServiceListenerTest.this.useService(reference);
                        }
                    });
                    future.run();
                    Object object = AbstractListenerHookServiceListenerTest.this.mutex1;
                    synchronized (object) {
                        Object object2 = AbstractListenerHookServiceListenerTest.this.mutex2;
                        synchronized (object2) {
                            if (AbstractListenerHookServiceListenerTest.this.task1 == null) {
                                AbstractListenerHookServiceListenerTest.this.task1 = future;
                                AbstractListenerHookServiceListenerTest.this.mutex1.notify();
                            } else if (AbstractListenerHookServiceListenerTest.this.task2 == null) {
                                AbstractListenerHookServiceListenerTest.this.task2 = future;
                                AbstractListenerHookServiceListenerTest.this.mutex2.notify();
                            }
                        }
                    }
                    return result;
                }
            };
            tracker.open();
            Thread.sleep(2000L);
            this.installDswIfNeeded();
            this.verifyGreeterResponse(this.task1, this.mutex1);
            this.verifyGreeterResponse(this.task2, this.mutex2);
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            if (server1 != null) {
                server1.getDestination().shutdown();
                server1.stop();
            }
            if (server2 != null) {
                server2.getDestination().shutdown();
                server2.stop();
            }
        }
    }

    public void testMultiServiceProxification() throws Exception {
        Thread.currentThread().setContextClassLoader(JAXRSClientFactoryBean.class.getClassLoader());
        this.bundleContext.registerService(new String[]{"javax.ws.rs.ext.MessageBodyReader"}, (Object)new AegisElementProvider(), new Hashtable());
        this.installDswIfNeeded();
        Thread.sleep(2000L);
        ServiceReference[] srefs = this.bundleContext.getAllServiceReferences(GreeterService.class.getName(), null);
        AbstractListenerHookServiceListenerTest.assertNotNull((Object)srefs);
        AbstractListenerHookServiceListenerTest.assertEquals((int)2, (int)srefs.length);
        String addr1 = (String)srefs[0].getProperty("org.apache.cxf.rs.address");
        String addr2 = (String)srefs[1].getProperty("org.apache.cxf.rs.address");
        AbstractListenerHookServiceListenerTest.assertNotNull((Object)addr1);
        AbstractListenerHookServiceListenerTest.assertNotNull((Object)addr2);
        AbstractListenerHookServiceListenerTest.assertTrue((String)("unexpected address property: " + addr1), (boolean)(ADDRESS1.equals(addr1) ^ ADDRESS2.equals(addr1)));
        AbstractListenerHookServiceListenerTest.assertTrue((String)("unexpected address property: " + addr2), (boolean)(ADDRESS1.equals(addr2) ^ ADDRESS2.equals(addr2)));
    }

    protected abstract boolean usingIntegralDsw();

    private void installDswIfNeeded() throws Exception {
        if (!this.usingIntegralDsw()) {
            this.installBundle("org.apache.cxf.dosgi", "cxf-dosgi-ri-dsw-cxf", null, "jar");
        }
    }

    private GreeterInfo useService(ServiceReference sref) {
        GreeterService hs = (GreeterService)this.bundleContext.getService(sref);
        AbstractListenerHookServiceListenerTest.assertNotNull((Object)hs);
        try {
            return hs.greetMe("Fred");
        }
        catch (Exception ex) {
            AbstractListenerHookServiceListenerTest.fail((String)"unexpected exception");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGreeterResponse(FutureTask<GreeterInfo> task, Object mutex) throws Exception {
        GreeterInfo greetings = null;
        Object object = mutex;
        synchronized (object) {
            while (task == null) {
                mutex.wait(500L);
            }
            greetings = task.get();
        }
        AbstractListenerHookServiceListenerTest.assertEquals((String)"4 greetings expected", (int)4, (int)greetings.getGreetings().size());
    }

    private Server startServer(String address, Class<?> type, Object impl) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setServiceClass(type);
        factory.setAddress(address);
        factory.setResourceProvider(type, (ResourceProvider)new SingletonResourceProvider(impl));
        ArrayList<AegisElementProvider> providers = new ArrayList<AegisElementProvider>();
        providers.add(new AegisElementProvider());
        factory.setProviders(providers);
        return factory.create();
    }

    private class GreeterServiceImpl
    implements GreeterService {
        private static final String STRANGER_NAME = "Stranger";

        private GreeterServiceImpl() {
        }

        public GreeterInfo greetMe(String name) throws GreeterException {
            System.out.println("Invoking: greetMe(" + name + ")");
            if (name.equals(STRANGER_NAME)) {
                throw new GreeterException(name);
            }
            GreeterInfo info = new GreeterInfo();
            ArrayList<GreetingPhrase> list = new ArrayList<GreetingPhrase>();
            list.add(new GreetingPhrase("Hello", name));
            list.add(new GreetingPhrase("Hoi", name));
            list.add(new GreetingPhrase("Hola", name));
            list.add(new GreetingPhrase("Bonjour", name));
            info.setGreetings(list);
            return info;
        }
    }
}

