/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.systests.common.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.cxf.dosgi.samples.greeter.rest.GreeterInfo;
import org.apache.cxf.dosgi.samples.greeter.rest.GreeterService;
import org.apache.cxf.dosgi.samples.greeter.rest.GreetingPhrase;
import org.apache.cxf.dosgi.systests.common.rest.AbstractDosgiSystemTest;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;

public abstract class AbstractJaxRsPublishHookTest
extends AbstractDosgiSystemTest {
    protected String[] getTestBundlesNames() {
        return new String[]{this.getBundle("org.apache.cxf.dosgi.systests", "cxf-dosgi-ri-systests-common-rest"), this.getBundle("org.apache.cxf.dosgi.samples", "cxf-dosgi-ri-samples-greeter-rest-interface"), this.getBundle("org.apache.servicemix.specs", "org.apache.servicemix.specs.jsr311-api-1.0")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInvocation() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "cxf-dsw");
        ServiceReference[] srefs = this.bundleContext.getAllServiceReferences(ManagedService.class.getName(), "(service.pid=cxf-dsw)");
        AbstractJaxRsPublishHookTest.assertNotNull((Object)srefs);
        AbstractJaxRsPublishHookTest.assertEquals((int)1, (int)srefs.length);
        ManagedService ms = (ManagedService)this.bundleContext.getService(srefs[0]);
        ms.updated(props);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JAXRSClientFactoryBean.class.getClassLoader());
        this.installBundle("org.apache.cxf.dosgi.samples", "cxf-dosgi-ri-samples-greeter-rest-impl", null, "jar");
        String address = "http://localhost:9090/greeter";
        this.waitForEndpoint(address + "/greeter");
        GreeterService greeter1 = null;
        boolean serviceUsed = false;
        try {
            JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
            factory.setServiceClass(GreeterService.class);
            factory.setAddress(address);
            factory.setProvider((Object)new AegisElementProvider());
            greeter1 = (GreeterService)factory.create();
            serviceUsed = this.useService(greeter1);
        }
        finally {
            AbstractJaxRsPublishHookTest.assertTrue((boolean)serviceUsed);
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private void waitForEndpoint(String address) throws Exception {
        URL wsdlURL = new URL(address + "?_wadl");
        for (int counter = 1; counter <= 10; ++counter) {
            Thread.sleep(2000L);
            try {
                String line;
                BufferedReader is = new BufferedReader(new InputStreamReader(wsdlURL.openStream()));
                while ((line = is.readLine()) != null) {
                    if (!line.contains("application")) continue;
                    System.out.println("Waited for endpoint for " + counter * 2 + " secs");
                    return;
                }
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        System.out.println("Failed to retrieve service wadl during 20 sec");
        AbstractJaxRsPublishHookTest.fail();
    }

    private boolean useService(GreeterService greeter) throws Exception {
        AbstractJaxRsPublishHookTest.assertNotNull((Object)greeter);
        GreeterInfo info = greeter.greetMe("Fred");
        AbstractJaxRsPublishHookTest.assertTrue((info.getGreetings().size() > 0 ? 1 : 0) != 0);
        for (GreetingPhrase greeting : info.getGreetings()) {
            AbstractJaxRsPublishHookTest.assertEquals((String)"Fred", (String)greeting.getName());
            System.out.println("  " + greeting.getPhrase() + " " + greeting.getName());
        }
        return true;
    }
}

