/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.systests.common.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.AbstractConfigurableBundleCreatorTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDosgiSystemTest
extends AbstractConfigurableBundleCreatorTests {
    private Properties dependencies;

    protected String getBundle(String groupId, String artifactId) {
        return groupId + "," + artifactId + "," + this.getBundleVersion(groupId, artifactId);
    }

    protected String getBundleVersion(String groupId, String artifactId) {
        String version;
        if (this.dependencies == null) {
            try {
                File f = new File(System.getProperty("basedir"), "target/classes/META-INF/maven/dependencies.properties");
                Properties prop = new Properties();
                prop.load(new FileInputStream(f));
                this.dependencies = prop;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load dependencies informations", e);
            }
        }
        if ((version = this.dependencies.getProperty(groupId + "/" + artifactId + "/version")) == null) {
            throw new IllegalStateException("Unable to find dependency information for: " + groupId + "/" + artifactId + "/version");
        }
        return version;
    }

    protected File localMavenBundle(String groupId, String artifact, String version, String classifier, String type) {
        String defaultHome = new File(new File(System.getProperty("user.home")), ".m2/repository").getAbsolutePath();
        File repositoryHome = new File(System.getProperty("localRepository", defaultHome));
        StringBuffer location = new StringBuffer(groupId.replace('.', '/'));
        location.append('/');
        location.append(artifact);
        location.append('/');
        location.append(AbstractDosgiSystemTest.getSnapshot(version));
        location.append('/');
        location.append(artifact);
        location.append('-');
        location.append(version);
        if (classifier != null) {
            location.append('-');
            location.append(classifier);
        }
        location.append(".");
        location.append(type);
        return new File(repositoryHome, location.toString());
    }

    protected static boolean isTimestamped(String version) {
        return version.matches(".+-\\d\\d\\d\\d\\d\\d\\d\\d\\.\\d\\d\\d\\d\\d\\d-\\d+");
    }

    protected static String getSnapshot(String version) {
        if (AbstractDosgiSystemTest.isTimestamped(version)) {
            return version.substring(0, version.lastIndexOf(45, version.lastIndexOf(45) - 1)) + "-SNAPSHOT";
        }
        return version;
    }

    protected void installBundle(String groupId, String artifactId, String classifier, String type) throws Exception {
        String version = this.getBundleVersion(groupId, artifactId);
        File loc = this.localMavenBundle(groupId, artifactId, version, classifier, type);
        Bundle bundle = this.bundleContext.installBundle(loc.toURI().toString());
        bundle.start();
    }

    protected Manifest getManifest() {
        Manifest mf = super.getManifest();
        String importP = mf.getMainAttributes().getValue("Import-Package");
        mf.getMainAttributes().putValue("Import-Package", importP);
        mf.getMainAttributes().putValue("DynamicImport-Package", "*");
        return mf;
    }

    protected String[] getTestFrameworkBundlesNames() {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getTestFrameworkBundlesNames()));
        this.fixLog4J(names);
        names.add(this.getBundle("org.apache.felix", "org.osgi.compendium"));
        return names.toArray(new String[names.size()]);
    }

    private void fixLog4J(List<String> names) {
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            if (!it.next().equals("org.springframework.osgi,log4j.osgi,1.2.15-SNAPSHOT")) continue;
            it.remove();
            break;
        }
        names.add("org.apache.log4j,com.springsource.org.apache.log4j,1.2.15");
    }

    protected Resource[] getTestBundles() {
        ArrayList<String> frameworkBundleNames = new ArrayList<String>();
        for (Resource r : this.getTestFrameworkBundles()) {
            frameworkBundleNames.add(r.getFilename());
        }
        try {
            ArrayList<Object> resources = new ArrayList<Object>();
            for (File file : this.getDistributionBundles()) {
                if (frameworkBundleNames.contains(file.getName())) continue;
                resources.add(new FileSystemResource(file));
            }
            resources.addAll(Arrays.asList(super.getTestBundles()));
            return resources.toArray(new Resource[resources.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract File[] getDistributionBundles() throws Exception;
}

