/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.samples.greeter.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.dosgi.samples.greeter.GreeterData;
import org.apache.cxf.dosgi.samples.greeter.GreeterException;
import org.apache.cxf.dosgi.samples.greeter.GreeterService;
import org.apache.cxf.dosgi.samples.greeter.GreetingPhrase;
import org.apache.cxf.dosgi.samples.greeter.client.GreeterDialog;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker<GreeterService, GreeterService> tracker;
    private ConcurrentHashMap<GreeterService, GreeterDialog> dialogs = new ConcurrentHashMap();

    public void start(BundleContext bc) {
        this.tracker = new ServiceTracker<GreeterService, GreeterService>(bc, GreeterService.class, null){

            public GreeterService addingService(ServiceReference<GreeterService> reference) {
                GreeterService service = (GreeterService)super.addingService(reference);
                Activator.this.dialogs.put(service, new GreeterDialog());
                Activator.this.useService(service);
                return service;
            }

            public void removedService(ServiceReference<GreeterService> reference, GreeterService service) {
                super.removedService(reference, (Object)service);
                GreeterDialog dialog = (GreeterDialog)Activator.this.dialogs.remove(service);
                dialog.dispose();
            }
        };
        this.tracker.open();
    }

    protected void useService(final GreeterService greeter) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Activator.this.greeterUI(greeter);
            }
        });
        t.start();
    }

    private void greeterUI(GreeterService greeter) {
        GreeterDialog dialog;
        block2: while ((dialog = this.dialogs.get(greeter)) != null) {
            GreetingPhrase[] result;
            System.out.println("*** Opening greeter client dialog ***");
            dialog.resetSelection();
            dialog.setVisible(true);
            Object gd = dialog.getSelection();
            if (gd instanceof String) {
                System.out.println("*** Invoking greeter ***");
                result = greeter.greetMe((String)gd);
                System.out.println("greetMe(\"" + gd + "\") returns:");
                Iterator i$ = result.entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Map.Entry greeting = i$.next();
                    System.out.println("  " + ((GreetingPhrase)greeting.getKey()).getPhrase() + " " + (String)greeting.getValue());
                }
            }
            if (!(gd instanceof GreeterData)) continue;
            System.out.println("*** Invoking greeter ***");
            try {
                result = greeter.greetMe((GreeterData)gd);
                System.out.println("greetMe(\"" + gd + "\") returns:");
                GreetingPhrase[] arr$ = result;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block2;
                    GreetingPhrase phrase = arr$[i$];
                    System.out.println("  " + phrase.getPhrase());
                    ++i$;
                }
            }
            catch (GreeterException ex) {
                System.out.println("GreeterException: " + ex.toString());
                continue;
            }
            break;
        }
        return;
    }

    public void stop(BundleContext bc) throws Exception {
        this.tracker.close();
    }
}

