/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.samples.discovery.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.cxf.dosgi.samples.discovery.DisplayService;
import org.apache.cxf.dosgi.samples.discovery.impl.DisplayServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ServiceRegistration reg;

    public void start(BundleContext bc) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        String host = Activator.getHostName();
        int port = Activator.getPort();
        ((Dictionary)props).put("service.exported.interfaces", "*");
        ((Dictionary)props).put("service.exported.configs", "org.apache.cxf.ws");
        ((Dictionary)props).put("org.apache.cxf.ws.address", Activator.getAddress(host, port));
        ((Dictionary)props).put("endpoint.id", Activator.getAddress(host, port));
        this.reg = bc.registerService(DisplayService.class.getName(), (Object)new DisplayServiceImpl(host + ":" + port), props);
    }

    private static String getAddress(String host, int port) {
        return "http://" + host + ":" + port + "/display";
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static int getPort() throws IOException {
        return new ServerSocket(0).getLocalPort();
    }

    public void stop(BundleContext bc) throws Exception {
        this.reg.unregister();
    }
}

