/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.samples.discovery.consumer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.dosgi.samples.discovery.DisplayService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker tracker;
    private Map<DisplayService, String> displays = new ConcurrentHashMap<DisplayService, String>();
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> handle;

    public void start(BundleContext bc) throws Exception {
        this.tracker = new ServiceTracker(bc, DisplayService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                if (svc instanceof DisplayService) {
                    DisplayService d = (DisplayService)svc;
                    System.out.println("Adding display: " + d.getID() + " (" + d + ")");
                    Activator.this.displays.put(d, d.getID());
                }
                return svc;
            }

            public void removedService(ServiceReference reference, Object service) {
                String value = (String)Activator.this.displays.remove(service);
                System.out.println("Removed display: " + value);
                super.removedService(reference, service);
            }
        };
        this.tracker.open();
        this.scheduler = Executors.newScheduledThreadPool(1);
        Runnable printer = new Runnable(){
            int counter;

            @Override
            public void run() {
                ++this.counter;
                String text = "some text " + this.counter;
                System.out.println("Sending text to displays: " + text);
                for (Map.Entry entry : Activator.this.displays.entrySet()) {
                    try {
                        ((DisplayService)entry.getKey()).displayText(text);
                    }
                    catch (Throwable th) {
                        System.out.println("Could not send message to display: " + (String)entry.getValue());
                    }
                }
            }
        };
        this.handle = this.scheduler.scheduleAtFixedRate(printer, 5L, 5L, TimeUnit.SECONDS);
    }

    public void stop(BundleContext bc) throws Exception {
        this.handle.cancel(true);
        this.tracker.close();
    }
}

