/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointDescriptionImpl
implements ServiceEndpointDescription {
    private static final Logger LOG = Logger.getLogger(ServiceEndpointDescriptionImpl.class.getName());
    private Set<String> interfaceNames;
    private Map<String, Object> properties;

    public ServiceEndpointDescriptionImpl(String interfaceName) {
        this(Collections.singletonList(interfaceName), (Map<String, Object>)Collections.EMPTY_MAP);
    }

    public ServiceEndpointDescriptionImpl(String interfaceName, Map<String, Object> remoteProperties) {
        this(Collections.singletonList(interfaceName), remoteProperties);
    }

    public ServiceEndpointDescriptionImpl(List<String> interfaceNames) {
        this(interfaceNames, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    public ServiceEndpointDescriptionImpl(List<String> interfaceNames, Map<String, Object> remoteProperties) {
        this.interfaceNames = new HashSet<String>(interfaceNames);
        this.properties = remoteProperties;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Collection getPropertyKeys() {
        return this.getProperties().keySet();
    }

    public int hashCode() {
        return ((Object)this.interfaceNames).hashCode() + 37 * ((Object)this.properties).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceEndpointDescription)) {
            return false;
        }
        ServiceEndpointDescription other = (ServiceEndpointDescription)obj;
        if (this == other) {
            return true;
        }
        return ((Object)this.interfaceNames).equals(other.getProvidedInterfaces()) && ((Object)this.properties).equals(other.getProperties());
    }

    @Override
    public URI getLocation() {
        Object value = this.properties.get("osgi.remote.endpoint.location");
        if (value == null) {
            return null;
        }
        try {
            return new URI(value.toString());
        }
        catch (URISyntaxException ex) {
            LOG.warning("Service document URL is malformed : " + value.toString());
            return null;
        }
    }

    @Override
    public Collection<String> getProvidedInterfaces() {
        return this.interfaceNames;
    }

    @Override
    public String getVersion(String interfaceName) {
        return "0.0";
    }

    @Override
    public String getEndpointInterfaceName(String interfaceName) {
        return interfaceName;
    }

    @Override
    public String getEndpointID() {
        return null;
    }
}

