/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.hooks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.hooks.AbstractHook;
import org.apache.cxf.dosgi.dsw.hooks.EndpointInfo;
import org.apache.cxf.dosgi.dsw.hooks.ServiceHookUtils;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.Server;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfPublishHook
extends AbstractHook {
    protected Map<ServiceReference, List<EndpointInfo>> endpoints = new LinkedHashMap<ServiceReference, List<EndpointInfo>>();
    private Map<ServiceReference, ServiceRegistration> publications = new LinkedHashMap<ServiceReference, ServiceRegistration>();

    public CxfPublishHook(BundleContext bc, CxfDistributionProvider dpService) {
        super(bc, dpService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishEndpoint(ServiceReference sref) {
        String[] publishableInterfaces;
        Map<ServiceReference, List<EndpointInfo>> map = this.endpoints;
        synchronized (map) {
            if (this.endpoints.containsKey(sref)) {
                return;
            }
        }
        if (ServiceHookUtils.isCreatedByDsw(sref)) {
            return;
        }
        ServiceEndpointDescription sd = null;
        if (this.checkBundle()) {
            sd = OsgiUtils.getRemoteReference(sref, true);
        }
        String[] stringArray = publishableInterfaces = sd != null ? OsgiUtils.getPublishableInterfaces(sd, sref) : null;
        if (publishableInterfaces == null || publishableInterfaces.length == 0) {
            return;
        }
        ServiceEndpointDescription[] flatList = OsgiUtils.flattenServiceDescription(sd);
        for (int i = 0; i < publishableInterfaces.length; ++i) {
            boolean isPublished = false;
            Server server = this.createServer(sref, flatList[i]);
            if (server != null) {
                ServiceRegistration publication = ServiceHookUtils.publish(this.getContext(), sref, flatList[i]);
                this.publications.put(sref, publication);
                isPublished = publication != null;
            }
            Map<ServiceReference, List<EndpointInfo>> map2 = this.endpoints;
            synchronized (map2) {
                EndpointInfo ei = new EndpointInfo(this.getContext(), flatList[i], server, isPublished);
                if (this.endpoints.containsKey(sref)) {
                    this.endpoints.get(sref).add(ei);
                } else {
                    ArrayList<EndpointInfo> endpointList = new ArrayList<EndpointInfo>();
                    endpointList.add(ei);
                    this.endpoints.put(sref, endpointList);
                }
                continue;
            }
        }
    }

    Server createServer(ServiceReference sref, ServiceEndpointDescription sd) {
        return ServiceHookUtils.createServer(this.getHandler(sd, this.getHandlerProperties()), sref, this.getContext(), sref.getBundle().getBundleContext(), sd, this.getContext().getService(sref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoint(ServiceReference sref) {
        List<EndpointInfo> endpointList = null;
        Map<ServiceReference, List<EndpointInfo>> map = this.endpoints;
        synchronized (map) {
            endpointList = this.endpoints.remove(sref);
        }
        if (endpointList != null) {
            for (EndpointInfo ei : endpointList) {
                ServiceHookUtils.unregisterServer(this.publications.get(sref), ei);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoints() {
        Map<ServiceReference, List<EndpointInfo>> map = this.endpoints;
        synchronized (map) {
            for (ServiceReference sref : this.endpoints.keySet()) {
                List<EndpointInfo> endpointList = this.endpoints.get(sref);
                for (EndpointInfo ei : endpointList) {
                    ServiceHookUtils.unregisterServer(this.publications.get(sref), ei);
                }
            }
            this.endpoints.clear();
        }
    }

    public Map<ServiceReference, List<EndpointInfo>> getEndpoints() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    protected ConfigurationTypeHandler getHandler(ServiceEndpointDescription sd, Map<String, Object> props) {
        return ServiceHookUtils.getHandler(this.getContext(), sd, this.getDistributionProvider(), props);
    }
}

