/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.hooks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.dosgi.dsw.hooks.AbstractClientHook;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class CxfFindListenerHook
extends AbstractClientHook
implements ListenerHook,
FindHook {
    private static final Logger LOG = Logger.getLogger(CxfFindListenerHook.class.getName());
    private static final String CLASS_NAME_EXPRESSION = ".*\\(objectClass=([a-zA-Z_0-9.]+)\\).*";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile(".*\\(objectClass=([a-zA-Z_0-9.]+)\\).*");
    private static final String CLASS_NAME_BASE = "(objectClass=";
    private static final Set<String> SYSTEM_PACKAGES = new HashSet<String>();

    public CxfFindListenerHook(BundleContext bc, CxfDistributionProvider dp) {
        super(bc, dp);
    }

    public void added(Collection listeners) {
        this.handleListeners(listeners);
    }

    public void removed(Collection listener) {
    }

    private void handleListeners(Collection listeners) {
        for (ListenerHook.ListenerInfo listener : listeners) {
            String className = this.getClassNameFromFilter(listener.getFilter());
            if (listener.getFilter() == null || listener.getBundleContext() == this.getContext() || CxfFindListenerHook.isClassExcluded(className)) continue;
            if (this.onlyClassNameInFilter(className, listener.getFilter())) {
                this.lookupDiscoveryService(className, null);
                continue;
            }
            String filter = listener.getFilter().replaceAll("objectClass", "osgi.remote.service.interfaces");
            this.lookupDiscoveryService(null, filter);
        }
    }

    public void find(BundleContext context, String className, String filter, boolean allServices, Collection references) {
        this.lookupDiscoveryService(className, filter);
    }

    private String getClassNameFromFilter(String filter) {
        Matcher matcher;
        if (filter != null && (matcher = CLASS_NAME_PATTERN.matcher(filter)).matches() && matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean onlyClassNameInFilter(String className, String filter) {
        return (CLASS_NAME_BASE + className + ")").equals(filter);
    }

    private static boolean isClassExcluded(String className) {
        if (className == null) {
            return true;
        }
        for (String p : SYSTEM_PACKAGES) {
            if (!className.startsWith(p)) continue;
            LOG.fine("Lookup for " + className + " is ignored");
            return true;
        }
        return false;
    }

    static {
        SYSTEM_PACKAGES.add("org.osgi.service");
        SYSTEM_PACKAGES.add("org.apache.felix");
        SYSTEM_PACKAGES.add("org.ops4j.pax.logging");
        SYSTEM_PACKAGES.add("ch.ethz.iks.slp");
        SYSTEM_PACKAGES.add("org.ungoverned.osgi.service");
        SYSTEM_PACKAGES.add("org.springframework.osgi.context.event.OsgiBundleApplicationContextListener");
        SYSTEM_PACKAGES.add("java.net.ContentHandler");
    }
}

