/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.hooks;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHook {
    private final CxfDistributionProvider distributionProvider;
    private volatile BundleContext bc;
    private volatile boolean checkBundleForMetadata = true;
    private volatile boolean useMasterMap = true;
    private volatile String defaultPort;
    private volatile String defaultHost;

    public AbstractHook(BundleContext bc, CxfDistributionProvider dp) {
        this.bc = bc;
        this.distributionProvider = dp;
    }

    protected BundleContext getContext() {
        return this.bc;
    }

    public void updateProperties(Dictionary d) {
        Object value = d.get("check.bundle");
        if (value != null) {
            this.checkBundleForMetadata = OsgiUtils.toBoolean(value.toString());
        }
        if ((value = d.get("use.master.map")) != null) {
            this.useMasterMap = OsgiUtils.toBoolean(value.toString());
        }
        this.defaultHost = (value = d.get("default.host")) == null ? "localhost" : value.toString();
        value = d.get("default.port");
        this.defaultPort = value == null ? "9000" : value.toString();
    }

    protected boolean checkBundle() {
        return this.checkBundleForMetadata;
    }

    protected Map<String, Object> getHandlerProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("default.port", this.defaultPort == null ? "9000" : this.defaultPort);
        props.put("default.host", this.defaultHost == null ? "localhost" : this.defaultHost);
        props.put("use.master.map", this.useMasterMap);
        return props;
    }

    protected String getIdentificationProperty() {
        Bundle b = this.bc.getBundle();
        Object name = b.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = b.getHeaders().get("Bundle-SymbolicName");
        }
        Object version = b.getHeaders().get("Bundle-Version");
        StringBuilder sb = new StringBuilder();
        sb.append(name.toString()).append(", version : " + version.toString());
        return sb.toString();
    }

    protected CxfDistributionProvider getDistributionProvider() {
        return this.distributionProvider;
    }
}

