/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.hooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.handlers.ClientServiceFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.hooks.AbstractHook;
import org.apache.cxf.dosgi.dsw.hooks.ServiceHookUtils;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClientHook
extends AbstractHook {
    private static final Logger LOG = Logger.getLogger(AbstractClientHook.class.getName());
    private DiscoveredServiceTracker tracker;
    private Dictionary trackerProperties = new Hashtable();
    private Map<String, ServiceRegistration> discoveredServices = new HashMap<String, ServiceRegistration>();
    ServiceRegistration trackerRegistration;

    protected AbstractClientHook(BundleContext bc, CxfDistributionProvider dp) {
        super(bc, dp);
        this.tracker = new DiscoveryCallback();
        this.trackerRegistration = bc.registerService(DiscoveredServiceTracker.class.getName(), (Object)this.tracker, this.trackerProperties);
    }

    protected void processNotification(DiscoveredServiceNotification notification, BundleContext requestingContext) {
        ServiceEndpointDescription sd = notification.getServiceEndpointDescription();
        if (sd.getProperty("service.exported.interfaces") == null && sd.getProperty("osgi.remote.interfaces") == null) {
            return;
        }
        ConfigurationTypeHandler handler = ServiceHookUtils.getHandler(this.getContext(), sd, this.getDistributionProvider(), this.getHandlerProperties());
        if (handler == null) {
            LOG.info("not proxifying service, config type handler null");
            return;
        }
        Collection<String> matchingInterfaces = this.getMatchingInterfaces(notification, requestingContext);
        for (String interfaceName : matchingInterfaces) {
            this.proxifyMatchingInterface(interfaceName, sd, handler, requestingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxifyMatchingInterface(String interfaceName, ServiceEndpointDescription sd, ConfigurationTypeHandler handler, BundleContext requestingContext) {
        block8: {
            try {
                Class iClass = this.getContext().getBundle().loadClass(interfaceName);
                if (iClass != null) {
                    BundleContext actualContext = this.getContext();
                    Class actualClass = requestingContext.getBundle().loadClass(interfaceName);
                    if (actualClass != iClass) {
                        LOG.info("Class " + interfaceName + " loaded by DSW's bundle context is not " + "equal to the one loaded by the requesting bundle context, " + "DSW will use the requesting bundle context to register " + "a proxy service");
                        iClass = actualClass;
                        actualContext = requestingContext;
                    }
                    Map<String, ServiceRegistration> map = this.discoveredServices;
                    synchronized (map) {
                        if (this.unknownEndpointId(sd)) {
                            ServiceRegistration proxyRegistration = actualContext.registerService(interfaceName, (Object)new ClientServiceFactory(actualContext, iClass, sd, handler), new Hashtable<String, Object>(this.getProperties(sd, handler)));
                            this.cacheEndpointId(sd, proxyRegistration);
                        }
                        break block8;
                    }
                }
                LOG.info("not proxifying service, cannot load interface class: " + interfaceName);
            }
            catch (ClassNotFoundException ex) {
                LOG.warning("No class can be found for " + interfaceName);
            }
        }
    }

    private Collection<String> getMatchingInterfaces(DiscoveredServiceNotification notification, BundleContext context) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String currInterface : notification.getServiceEndpointDescription().getProvidedInterfaces()) {
            boolean matched = false;
            Iterator matchedInterfaces = notification.getInterfaces().iterator();
            while (matchedInterfaces.hasNext() && !matched) {
                matched = currInterface.equals(matchedInterfaces.next());
                if (!matched) continue;
                matches.add(currInterface);
            }
            Iterator matchedFilters = notification.getFilters().iterator();
            while (matchedFilters.hasNext() && !matched) {
                String filterString = (String)matchedFilters.next();
                try {
                    Filter filter = context.createFilter(filterString);
                    matched = filter.match((Dictionary)this.getProperties(notification, currInterface));
                }
                catch (InvalidSyntaxException ise) {
                    LOG.warning("invalid filter syntax: " + filterString);
                }
                if (!matched) continue;
                matches.add(currInterface);
            }
        }
        return matches;
    }

    private Hashtable getProperties(DiscoveredServiceNotification notification, String interfaceName) {
        Hashtable ret = new Hashtable();
        Map properties = notification.getServiceEndpointDescription().getProperties();
        for (String key : notification.getServiceEndpointDescription().getPropertyKeys()) {
            ret.put(key, properties.get(key));
        }
        ret.put("osgi.remote.service.interfaces", interfaceName);
        return ret;
    }

    protected Map<String, Object> getProperties(ServiceEndpointDescription sd, ConfigurationTypeHandler handler) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(sd.getProperties());
        Iterator i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (!((String)e.getKey()).startsWith("service.exported")) continue;
            i.remove();
        }
        props.put("org.apache.cxf.remote.dsw.client", this.getIdentificationProperty());
        props.put("service.imported", "true");
        props.put("service.imported.configs", handler.getType());
        return props;
    }

    protected synchronized void lookupDiscoveryService(String interfaceName, String filterValue) {
        LOG.info("lookup discovery service: interface: " + interfaceName + " filter: " + filterValue);
        boolean change = false;
        if (interfaceName != null) {
            change |= this.append(this.trackerProperties, "osgi.remote.discovery.interest.interfaces", interfaceName);
        }
        if (filterValue != null) {
            change |= this.append(this.trackerProperties, "osgi.remote.discovery.interest.filters", filterValue);
        }
        if (change) {
            this.trackerRegistration.setProperties(this.trackerProperties);
        }
    }

    private boolean append(Dictionary properties, String key, String additional) {
        ArrayList<String> existing = (ArrayList<String>)properties.get(key);
        if (existing == null) {
            existing = new ArrayList<String>();
            properties.put(key, existing);
        }
        if (!existing.contains(additional)) {
            existing.add(additional);
            return true;
        }
        return false;
    }

    private boolean unknownEndpointId(ServiceEndpointDescription notified) {
        String endpointId = (String)notified.getProperty("osgi.remote.endpoint.id");
        if (endpointId != null) {
            boolean duplicate = this.discoveredServices.containsKey(endpointId);
            if (!duplicate) {
                LOG.info("registering proxy for endpoint ID: " + endpointId);
            } else {
                LOG.info("ignoring duplicate notification for endpoint ID: " + endpointId);
            }
            return !duplicate;
        }
        LOG.warning("registering proxy with unknown duplicate status as endpoint ID unset");
        return true;
    }

    private void cacheEndpointId(ServiceEndpointDescription notified, ServiceRegistration registration) {
        String endpointId = (String)notified.getProperty("osgi.remote.endpoint.id");
        if (endpointId != null) {
            this.discoveredServices.put(endpointId, registration);
            LOG.info("caching proxy registration for endpoint ID: " + endpointId);
        } else {
            LOG.warning("cannot cache proxy registration as endpoint ID unset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCacheEndpointId(ServiceEndpointDescription notified) {
        String endpointId = (String)notified.getProperty("osgi.remote.endpoint.id");
        ServiceRegistration proxyRegistration = null;
        if (endpointId != null) {
            Map<String, ServiceRegistration> map = this.discoveredServices;
            synchronized (map) {
                proxyRegistration = this.discoveredServices.remove(endpointId);
            }
        }
        if (proxyRegistration != null) {
            LOG.info("unregistering proxy service for endpoint ID: " + endpointId);
            proxyRegistration.unregister();
        }
    }

    private class DiscoveryCallback
    implements DiscoveredServiceTracker {
        private DiscoveryCallback() {
        }

        public void serviceChanged(DiscoveredServiceNotification notification) {
            ServiceEndpointDescription notified = notification.getServiceEndpointDescription();
            switch (notification.getType()) {
                case 1: {
                    LOG.info("Notified - AVAILABLE: " + notified.getProvidedInterfaces() + " endpoint id: " + notification.getServiceEndpointDescription().getProperty("osgi.remote.endpoint.id"));
                    AbstractClientHook.this.processNotification(notification, AbstractClientHook.this.getContext());
                    break;
                }
                case 4: {
                    LOG.info("Notified - UNAVAILABLE: " + notified.getProvidedInterfaces() + notified.getProvidedInterfaces() + " endpoint id: " + notification.getServiceEndpointDescription().getProperty("osgi.remote.endpoint.id"));
                    AbstractClientHook.this.unCacheEndpointId(notified);
                    break;
                }
                case 2: {
                    LOG.info("Notified - MODIFIED: " + notified.getProvidedInterfaces());
                }
            }
        }
    }
}

