/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSUtils;
import org.apache.cxf.dosgi.dsw.handlers.PojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSPojoConfigurationTypeHandler
extends PojoConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(JaxRSPojoConfigurationTypeHandler.class.getName());
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();

    protected JaxRSPojoConfigurationTypeHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        super(dswBC, dp, handlerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, ServiceEndpointDescription sd) {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + sd.getProvidedInterfaces().toArray()[0] + " client, endpoint address is " + address);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
            bean.setAddress(address);
            List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
            if (resources != null) {
                bean.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            } else {
                bean.setServiceClass(iClass);
            }
            List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd);
            if (providers != null && providers.size() > 0) {
                bean.setProviders(providers);
            }
            Thread.currentThread().setContextClassLoader(JAXRSClientFactoryBean.class.getClassLoader());
            Object proxy = this.getProxy(bean.create(), iClass);
            this.getDistributionProvider().addRemoteService(serviceReference);
            Object object = proxy;
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    @Override
    public Server createServer(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, ServiceEndpointDescription sd, Class<?> iClass, Object serviceBean) {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + sd.getProvidedInterfaces().toArray()[0] + " endpoint from CXF PublishHook, address is " + address);
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
        if (resources != null) {
            factory.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            factory.setServiceBeans(new Object[]{serviceBean});
        } else {
            factory.setServiceClass(iClass);
            factory.setResourceProvider(iClass, (ResourceProvider)new SingletonResourceProvider(serviceBean));
        }
        factory.setAddress(address);
        List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd);
        if (providers != null && providers.size() > 0) {
            factory.setProviders(providers);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = new String[]{"HTTP"};
            Thread.currentThread().setContextClassLoader(JAXRSServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            this.getDistributionProvider().addExposedService(serviceReference, this.registerPublication(server, intents));
            this.addAddressProperty(sd.getProperties(), address);
            Server server2 = server;
            return server2;
        }
        catch (IntentUnsatifiedException iue) {
            this.getDistributionProvider().intentsUnsatisfied(serviceReference);
            throw iue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    protected String getPojoAddress(ServiceEndpointDescription sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        if (address == null && (address = this.getDefaultAddress(iClass)) != null) {
            LOG.info("Using a default address : " + address);
        }
        return address;
    }
}

