/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSUtils;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSHttpServiceConfigurationTypeHandler
extends HttpServiceConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(JaxRSHttpServiceConfigurationTypeHandler.class.getName());
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();

    protected JaxRSHttpServiceConfigurationTypeHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        super(dswBC, dp, handlerProps);
    }

    @Override
    public Server createServer(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, ServiceEndpointDescription sd, Class<?> iClass, Object serviceBean) {
        String contextRoot = this.getServletContextRoot(sd, iClass);
        if (contextRoot == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        CXFNonSpringServlet cxf = new CXFNonSpringServlet();
        HttpService httpService = this.getHttpService();
        try {
            httpService.registerServlet(contextRoot, (Servlet)cxf, new Hashtable(), null);
            LOG.info("Successfully registered CXF DOSGi servlet at " + contextRoot);
        }
        catch (Exception e) {
            throw new ServiceException("CXF DOSGi: problem registering CXF HTTP Servlet", (Throwable)e);
        }
        Bus bus = cxf.getBus();
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setBus(bus);
        List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
        if (resources != null) {
            factory.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            factory.setServiceBeans(new Object[]{serviceBean});
        } else {
            factory.setServiceClass(iClass);
            factory.setResourceProvider(iClass, (ResourceProvider)new SingletonResourceProvider(serviceBean));
        }
        factory.setAddress("/");
        List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd);
        if (providers != null && providers.size() > 0) {
            factory.setProviders(providers);
        }
        String address = this.constructAddress(dswContext, contextRoot);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = new String[]{"HTTP"};
            Thread.currentThread().setContextClassLoader(JAXRSServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            this.registerStopHook(bus, httpService, server, contextRoot, "org.apache.cxf.rs.httpservice.context");
            this.getDistributionProvider().addExposedService(serviceReference, this.registerPublication(server, intents, address));
            this.addAddressProperty(sd.getProperties(), address);
            Server server2 = server;
            return server2;
        }
        catch (IntentUnsatifiedException iue) {
            this.getDistributionProvider().intentsUnsatisfied(serviceReference);
            throw iue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    protected String getServletContextRoot(ServiceEndpointDescription sd, Class<?> iClass) {
        String context = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.httpservice.context");
        if (context == null) {
            context = "/" + iClass.getName().replace('.', '/');
            LOG.info("Using a default address : " + context);
        }
        return context;
    }
}

